/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.creeperhost.equivalentexchange.EquivalentExchange;
import net.creeperhost.equivalentexchange.api.EquivalentExchangeTags;
import net.creeperhost.equivalentexchange.api.IEmcRecipeParser;
import net.creeperhost.equivalentexchange.api.IEmcStorageHandler;
import net.creeperhost.equivalentexchange.api.IKnowledgeHandler;
import net.creeperhost.equivalentexchange.api.events.EmcRegisterEvent;
import net.creeperhost.equivalentexchange.api.recipe.InWorldTransmutation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class EquivalentExchangeAPI {
    public static IEmcStorageHandler iEmcStorageHandler;
    public static IKnowledgeHandler iKnowledgeHandler;
    public static HashMap<ResourceLocation, Double> EMC_VALUES;
    public static boolean UpdatingValues;
    public static List<InWorldTransmutation> IN_WORLD_TRANSMUTATION_RECIPES;
    public static Map<RecipeType<?>, IEmcRecipeParser> PARSERS;

    @Deprecated
    public static void registerInWorldTransmutationRecipe(BlockState input, BlockState output, @Nullable BlockState altOutput) {
        InWorldTransmutation inWorldTransmutation = new InWorldTransmutation(input, output, altOutput);
        IN_WORLD_TRANSMUTATION_RECIPES.add(inWorldTransmutation);
    }

    public static void registerParser(RecipeType<?> recipe, IEmcRecipeParser parser) {
        if (!PARSERS.containsKey(recipe)) {
            PARSERS.put(recipe, parser);
        }
    }

    public static boolean hasEmcValue(ItemStack itemStack) {
        ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        return EMC_VALUES.containsKey(resourceLocation);
    }

    public static void setEmcValue(Item item, double value) {
        ItemStack stack = new ItemStack((ItemLike)item);
        EquivalentExchangeAPI.setEmcValue(stack, value);
    }

    public static void setEmcValue(ItemStack itemStack, double value) {
        ((EmcRegisterEvent.Set)EmcRegisterEvent.EMC_SET_EVENT.invoker()).set(itemStack);
        if (value <= 0.0) {
            EquivalentExchange.LOGGER.error("Tried to set emc value for {} to value of 0 or less {}", (Object)itemStack.getDisplayName().getString(), (Object)value);
            return;
        }
        if (EquivalentExchangeTags.isBlacklisted(itemStack)) {
            return;
        }
        ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        if (!EquivalentExchangeAPI.hasEmcValue(itemStack)) {
            EMC_VALUES.put(resourceLocation, value);
        }
    }

    public static double getEmcValue(ItemStack itemStack) {
        if (EquivalentExchangeAPI.hasEmcValue(itemStack)) {
            ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
            return EMC_VALUES.get(resourceLocation);
        }
        return 0.0;
    }

    public static IEmcStorageHandler getStorageHandler() {
        return iEmcStorageHandler;
    }

    public static IKnowledgeHandler getKnowledgeHandler() {
        return iKnowledgeHandler;
    }

    static {
        EMC_VALUES = new HashMap();
        UpdatingValues = false;
        IN_WORLD_TRANSMUTATION_RECIPES = new ArrayList<InWorldTransmutation>();
        PARSERS = new HashMap();
    }
}

