/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.blockentities;

import net.creeperhost.equivalentexchange.api.emcstorage.IEmcStorage;
import net.creeperhost.equivalentexchange.blockentities.prefab.EmcBlockEntity;
import net.creeperhost.equivalentexchange.blocks.BlockCollector;
import net.creeperhost.equivalentexchange.containers.ContainerCollector;
import net.creeperhost.equivalentexchange.init.ModBlocks;
import net.creeperhost.polylib.data.DataManagerBlock;
import net.creeperhost.polylib.data.TileDataManager;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.data.serializable.DoubleData;
import net.creeperhost.polylib.data.serializable.IntData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityCollector
extends EmcBlockEntity
implements DataManagerBlock {
    private final TileDataManager<BlockEntityCollector> dataManager = new TileDataManager((BlockEntity)this);
    public DoubleData storedEMC = (DoubleData)this.dataManager.register("stored_emc", (AbstractDataStore)new DoubleData(0.0), new int[]{4});
    public IntData lightLevel = (IntData)this.dataManager.register("light_level", (AbstractDataStore)new IntData(0), new int[]{4});
    int ticks = 0;

    public BlockEntityCollector(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.COLLECTOR_TILE.get(), blockPos, blockState, 0.0, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
    }

    @Override
    public double getMaxStored() {
        if (this.level == null) {
            return 0.0;
        }
        Block block = this.level.getBlockState(this.getBlockPos()).getBlock();
        if (block instanceof BlockCollector) {
            BlockCollector blockCollector = (BlockCollector)block;
            return blockCollector.getCollectorType().getMaxStorage();
        }
        return 0.0;
    }

    public void tick() {
        if (this.level == null) {
            return;
        }
        if (!this.level.isClientSide) {
            ++this.ticks;
            if (this.ticks >= 20) {
                this.ticks = 0;
                this.lightLevel.set((Object)(this.level.getMaxLocalRawBrightness(this.worldPosition.above()) + 1));
                BlockState state = this.getBlockState();
                Block block = state.getBlock();
                if (block instanceof BlockCollector) {
                    BlockCollector blockCollector = (BlockCollector)block;
                    double generation = blockCollector.getCollectorType().getGeneration() * 20.0;
                    this.receiveEmc(generation, false);
                    for (Direction value : Direction.values()) {
                        IEmcStorage iEmcStorage;
                        BlockEntity blockEntity;
                        BlockPos blockPos = this.getBlockPos().relative(value);
                        if (this.level.getBlockEntity(blockPos) == null || !((blockEntity = this.level.getBlockEntity(blockPos)) instanceof IEmcStorage) || !(iEmcStorage = (IEmcStorage)blockEntity).canReceive()) continue;
                        double removed = iEmcStorage.receiveEmc(Math.min(this.getStoredEmc(), blockCollector.getCollectorType().getGeneration() * 20.0), false);
                        this.extractEmc(removed, false);
                    }
                }
            }
            this.storedEMC.set((Object)this.getStoredEmc());
        }
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"equivalentexchange.collector");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, @NotNull Inventory inventory, @NotNull Player player) {
        return new ContainerCollector(i, inventory, this);
    }

    @Override
    public void load(@NotNull CompoundTag compoundTag) {
        super.load(compoundTag);
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag compoundTag) {
        super.saveAdditional(compoundTag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public TileDataManager<?> getDataManager() {
        return this.dataManager;
    }
}

