/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.blockentities;

import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.creeperhost.equivalentexchange.blockentities.prefab.EmcBlockEntity;
import net.creeperhost.equivalentexchange.containers.ContainerCondenser;
import net.creeperhost.equivalentexchange.init.ModBlocks;
import net.creeperhost.polylib.data.DataManagerBlock;
import net.creeperhost.polylib.data.TileDataManager;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.data.serializable.DoubleData;
import net.creeperhost.polylib.inventory.items.BlockInventory;
import net.creeperhost.polylib.inventory.items.ContainerAccessControl;
import net.creeperhost.polylib.inventory.items.PolyInventoryBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityCondenser
extends EmcBlockEntity
implements DataManagerBlock,
PolyInventoryBlock {
    private final BlockInventory simpleItemInventory = new BlockInventory((BlockEntity)this, 92).setStackValidator((integer, itemStack) -> EquivalentExchangeAPI.hasEmcValue(itemStack));
    private final TileDataManager<BlockEntityCondenser> dataManager = new TileDataManager((BlockEntity)this);
    public DoubleData storedEMC = (DoubleData)this.dataManager.register("stored_emc", (AbstractDataStore)new DoubleData(0.0), new int[]{4});
    public DoubleData targetEMC = (DoubleData)this.dataManager.register("target_emc", (AbstractDataStore)new DoubleData(0.0), new int[]{4});
    private final int TARGET_SLOT = 91;

    public BlockEntityCondenser(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.CONDENSER_TILE.get(), blockPos, blockState, 0.0, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
    }

    public void tick() {
        this.dataManager.tick();
        if (!this.getContainer(Direction.UP).getItem(91).isEmpty()) {
            ItemStack targetStack = this.getContainer(Direction.UP).getItem(91);
            if (!EquivalentExchangeAPI.hasEmcValue(targetStack)) {
                return;
            }
            for (int i = 0; i <= 90; ++i) {
                ItemStack stack;
                if (this.getContainer(Direction.UP).getItem(i).isEmpty() || !EquivalentExchangeAPI.hasEmcValue(stack = this.getContainer(Direction.UP).getItem(i)) || stack.is(this.getContainer(Direction.UP).getItem(91).getItem())) continue;
                double value = EquivalentExchangeAPI.getEmcValue(stack) * (double)stack.getCount();
                this.receiveEmc(value, false);
                this.getContainer(Direction.UP).setItem(i, ItemStack.EMPTY);
            }
            if (this.getStoredEmc() >= EquivalentExchangeAPI.getEmcValue(targetStack)) {
                ItemStack stack = targetStack.copy();
                stack.setCount(1);
                ItemStack inserted = this.moveOutput(stack);
                if (inserted.isEmpty()) {
                    this.extractEmc(EquivalentExchangeAPI.getEmcValue(targetStack), false);
                }
            }
        }
        this.storedEMC.set((Object)this.getStoredEmc());
        if (this.getContainer(Direction.UP).getItem(91).isEmpty()) {
            this.targetEMC.set((Object)0.0);
        } else {
            this.targetEMC.set((Object)EquivalentExchangeAPI.getEmcValue(this.getContainer(Direction.UP).getItem(91)));
        }
    }

    @Override
    public boolean canReceive() {
        return true;
    }

    public ItemStack moveOutput(ItemStack stack) {
        for (int i = 0; i <= 90; ++i) {
            int max;
            int count;
            if (this.getContainer(Direction.UP).getItem(i).isEmpty()) {
                this.getContainer(Direction.UP).setItem(i, stack);
                return ItemStack.EMPTY;
            }
            if (!ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)this.getContainer(Direction.UP).getItem(i)) || (count = this.getContainer(Direction.UP).getItem(i).getCount()) >= (max = this.getContainer(Direction.UP).getItem(i).getMaxStackSize())) continue;
            int newCount = count + 1;
            stack.setCount(newCount);
            this.getContainer(Direction.UP).setItem(i, stack);
            return ItemStack.EMPTY;
        }
        return stack;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.equivalentexchange.condenser");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new ContainerCondenser(id, inventory, this);
    }

    @Override
    public void load(@NotNull CompoundTag compoundTag) {
        super.load(compoundTag);
        this.simpleItemInventory.deserialize(compoundTag);
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag compoundTag) {
        super.saveAdditional(compoundTag);
        this.simpleItemInventory.serialize(compoundTag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public TileDataManager<?> getDataManager() {
        return this.dataManager;
    }

    public Container getContainer(@Nullable Direction side) {
        return new ContainerAccessControl((Container)this.simpleItemInventory, 0, 92).containerRemoveCheck((integer, itemStack) -> integer != 91);
    }
}

