/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.blockentities;

import net.creeperhost.equivalentexchange.api.item.IPedestalItem;
import net.creeperhost.equivalentexchange.blocks.BlockDarkMatterPedestal;
import net.creeperhost.equivalentexchange.containers.ContainerDarkMatterPedestal;
import net.creeperhost.equivalentexchange.init.ModBlocks;
import net.creeperhost.polylib.blocks.PolyBlockEntity;
import net.creeperhost.polylib.inventory.items.BlockInventory;
import net.creeperhost.polylib.inventory.items.PolyInventoryBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityPedestal
extends PolyBlockEntity
implements PolyInventoryBlock,
MenuProvider {
    public final BlockInventory simpleItemInventory = new BlockInventory((BlockEntity)this, 2);
    int targetSlot = 0;
    int klienStarSlot = 1;

    public BlockEntityPedestal(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.PEDESTAL_TILE.get(), pos, state);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.equivalentexchange.dm_pedestal");
    }

    public void tick() {
        if (this.level.getBlockState(this.getBlockPos()).getBlock() instanceof BlockDarkMatterPedestal && ((Boolean)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockDarkMatterPedestal.IS_ACTIVE)).booleanValue() && !this.getContainer(Direction.UP).getItem(this.targetSlot).isEmpty()) {
            ItemStack targetStack = this.getContainer(Direction.UP).getItem(this.targetSlot);
            Item item = targetStack.getItem();
            if (item instanceof IPedestalItem) {
                IPedestalItem iPedestalItem = (IPedestalItem)item;
                ItemStack klienStarStack = this.getContainer(Direction.UP).getItem(this.klienStarSlot);
                iPedestalItem.pedestalTick(this.level, this.getBlockPos(), targetStack, klienStarStack);
            }
            this.spawnParticleTypes();
        }
    }

    private void spawnParticleTypes() {
        int x = this.worldPosition.getX();
        int y = this.worldPosition.getY();
        int z = this.worldPosition.getZ();
        this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.2, (double)y + 0.3, (double)z + 0.2, 0.0, 0.0, 0.0);
        this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.2, (double)y + 0.3, (double)z + 0.5, 0.0, 0.0, 0.0);
        this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.2, (double)y + 0.3, (double)z + 0.8, 0.0, 0.0, 0.0);
        this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.5, (double)y + 0.3, (double)z + 0.2, 0.0, 0.0, 0.0);
        this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.5, (double)y + 0.3, (double)z + 0.8, 0.0, 0.0, 0.0);
        this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.8, (double)y + 0.3, (double)z + 0.2, 0.0, 0.0, 0.0);
        this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.8, (double)y + 0.3, (double)z + 0.5, 0.0, 0.0, 0.0);
        this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.8, (double)y + 0.3, (double)z + 0.8, 0.0, 0.0, 0.0);
        RandomSource rand = this.level.random;
        for (int i = 0; i < 3; ++i) {
            int j = rand.nextInt(2) * 2 - 1;
            int k = rand.nextInt(2) * 2 - 1;
            double d0 = (double)this.worldPosition.getX() + 0.5 + 0.25 * (double)j;
            double d1 = (float)this.worldPosition.getY() + rand.nextFloat();
            double d2 = (double)this.worldPosition.getZ() + 0.5 + 0.25 * (double)k;
            double d3 = rand.nextFloat() * (float)j;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.125;
            double d5 = rand.nextFloat() * (float)k;
            this.level.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5);
        }
    }

    public Container getContainer(@Nullable Direction side) {
        return this.simpleItemInventory;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new ContainerDarkMatterPedestal(i, inventory, this);
    }

    protected void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        this.simpleItemInventory.serialize(nbt);
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.simpleItemInventory.deserialize(nbt);
    }
}

