/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.blockentities.prefab;

import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.creeperhost.equivalentexchange.api.emcstorage.IEmcItem;
import net.creeperhost.equivalentexchange.api.emcstorage.IEmcStorage;
import net.creeperhost.equivalentexchange.api.item.IKleinStarItem;
import net.creeperhost.equivalentexchange.blockentities.prefab.EmcBlockEntity;
import net.creeperhost.polylib.inventory.items.BlockInventory;
import net.creeperhost.polylib.inventory.items.PolyInventoryBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityRelay
extends EmcBlockEntity
implements PolyInventoryBlock {
    public BlockInventory simpleItemInventory;
    public ContainerData containerData = new ContainerData(){

        public int get(int i) {
            switch (i) {
                case 0: {
                    return (int)BlockEntityRelay.this.getMaxStored();
                }
                case 1: {
                    return (int)BlockEntityRelay.this.getStoredEmc();
                }
            }
            return 0;
        }

        public void set(int i, int j) {
        }

        public int getCount() {
            return 2;
        }
    };
    int ticks = 0;

    public abstract double getTransferRate();

    public BlockEntityRelay(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState, double capacity) {
        super(blockEntityType, blockPos, blockState, capacity);
    }

    public void tick() {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        this.moveItems();
        this.burnItem();
        this.charge();
        this.discharge();
    }

    public void discharge() {
        ++this.ticks;
        if (this.ticks >= 20) {
            this.ticks = 0;
            for (Direction value : Direction.values()) {
                IEmcStorage iEmcStorage;
                BlockEntity blockEntity;
                BlockPos blockPos = this.getBlockPos().relative(value);
                if (this.level.getBlockEntity(blockPos) == null || !((blockEntity = this.level.getBlockEntity(blockPos)) instanceof IEmcStorage) || !(iEmcStorage = (IEmcStorage)blockEntity).canReceive()) continue;
                double removed = iEmcStorage.receiveEmc(Math.min(this.getStoredEmc(), this.getTransferRate()), false);
                this.extractEmc(removed, false);
            }
        }
    }

    public void burnItem() {
        if (!this.getContainer(Direction.UP).getItem(0).isEmpty()) {
            ItemStack stack = this.getContainer(Direction.UP).getItem(0);
            Item item = stack.getItem();
            if (item instanceof IKleinStarItem) {
                IKleinStarItem itemKleinStar = (IKleinStarItem)item;
                if (itemKleinStar.getKleinStarStored(stack) > 0.0) {
                    double energyRemoved = this.receiveEmc(Math.min(itemKleinStar.getKleinStarStored(stack), this.getTransferRate()), false);
                    itemKleinStar.extractKleinStarEmc(stack, energyRemoved, false);
                }
                return;
            }
            double value = EquivalentExchangeAPI.getEmcValue(stack);
            if (value == -1.0) {
                return;
            }
            double inserted = this.receiveEmc(value, true);
            if (inserted == value) {
                this.receiveEmc(value, false);
                this.getContainer(Direction.UP).getItem(0).shrink(1);
            }
        }
    }

    public void charge() {
        ItemStack stack;
        IEmcItem iEmcItem;
        Item item;
        if (!this.getContainer(Direction.UP).getItem(1).isEmpty() && (item = this.getContainer(Direction.UP).getItem(1).getItem()) instanceof IEmcItem && (iEmcItem = (IEmcItem)item).canReceive(stack = this.getContainer(Direction.UP).getItem(1))) {
            double energyRemoved = iEmcItem.receiveEmc(stack, Math.min(this.getStoredEmc(), this.getTransferRate()), false);
            this.extractEmc(energyRemoved, false);
        }
    }

    public void moveItems() {
        if (this.getContainer(Direction.UP).getItem(0).isEmpty()) {
            for (int i = 0; i < this.getContainer(Direction.UP).getContainerSize(); ++i) {
                if (i <= 1 || this.getContainer(Direction.UP).getItem(i).isEmpty()) continue;
                ItemStack stack = this.getContainer(Direction.UP).getItem(i);
                this.getContainer(Direction.UP).setItem(0, stack);
                this.getContainer(Direction.UP).setItem(i, ItemStack.EMPTY);
                this.getContainer(Direction.UP).setChanged();
                break;
            }
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag compoundTag) {
        super.saveAdditional(compoundTag);
        this.simpleItemInventory.serialize(compoundTag);
    }

    @Override
    public void load(@NotNull CompoundTag compoundTag) {
        super.load(compoundTag);
        this.getContainer(Direction.UP);
        this.simpleItemInventory.deserialize(compoundTag);
    }
}

