/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.blocks;

import dev.architectury.registry.menu.MenuRegistry;
import net.creeperhost.equivalentexchange.blockentities.BlockEntityPedestal;
import net.creeperhost.equivalentexchange.blocks.prefab.EEEntityBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockDarkMatterPedestal
extends EEEntityBlock {
    public static final BooleanProperty IS_ACTIVE = BooleanProperty.create((String)"is_active");
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), (VoxelShape)Block.box((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0)));

    public BlockDarkMatterPedestal(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{IS_ACTIVE});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof BlockEntityPedestal) {
                BlockEntityPedestal pedestal = (BlockEntityPedestal)t;
                pedestal.tick();
            }
        };
    }

    @NotNull
    public InteractionResult use(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        if (!level.isClientSide) {
            if (!player.isShiftKeyDown()) {
                MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)level.getBlockEntity(blockPos)), friendlyByteBuf -> friendlyByteBuf.writeBlockPos(blockPos));
                return InteractionResult.SUCCESS;
            }
            boolean currentState = (Boolean)blockState.getValue((Property)IS_ACTIVE);
            BlockState state = (BlockState)blockState.setValue((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(!currentState));
            level.setBlock(blockPos, state, 3);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntityPedestal(blockPos, blockState);
    }
}

