/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.client.renders;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.creeperhost.equivalentexchange.client.renders.RenderTypes;
import net.creeperhost.equivalentexchange.items.ItemPhilosophersStone;
import net.creeperhost.equivalentexchange.items.interfaces.IOverlayItem;
import net.creeperhost.equivalentexchange.items.tools.ItemDestructionCatalyst;
import net.creeperhost.polylib.helpers.VectorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class BlockOverlayRender {
    public static void render(PoseStack poseStack, ItemStack item) {
        IOverlayItem iOverlayItem;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (mc.level == null) {
            return;
        }
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        int hitRange = 10;
        BlockHitResult lookingAt = VectorHelper.getLookingAt((Player)mc.player, (ClipContext.Fluid)(item.getItem() instanceof ItemPhilosophersStone ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE), (int)hitRange);
        Item item2 = item.getItem();
        if (item2 instanceof IOverlayItem ? (iOverlayItem = (IOverlayItem)item2).blockIgnored(mc.level.getBlockState(lookingAt.getBlockPos())) : mc.level.getBlockState(lookingAt.getBlockPos()) == Blocks.AIR.defaultBlockState()) {
            return;
        }
        int range = 1;
        Color color = Color.WHITE;
        Item item3 = item.getItem();
        if (item3 instanceof IOverlayItem) {
            IOverlayItem iOverlayItem2 = (IOverlayItem)item3;
            range = iOverlayItem2.getRange(item);
            color = iOverlayItem2.getColour(item);
        }
        Map<Object, Object> coords = new HashMap();
        if (item.getItem() instanceof ItemPhilosophersStone) {
            coords = ItemPhilosophersStone.getChanges((Level)mc.level, lookingAt.getBlockPos(), (Player)mc.player, lookingAt.getDirection(), range);
        } else if (item.getItem() instanceof ItemDestructionCatalyst) {
            coords = ItemDestructionCatalyst.getChanges((Level)mc.level, lookingAt.getBlockPos(), (Player)mc.player, lookingAt.getDirection(), range);
        }
        Vec3 view = mc.gameRenderer.getMainCamera().getPosition();
        poseStack.pushPose();
        poseStack.translate(-view.x(), -view.y(), -view.z());
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        VertexConsumer builder = buffer.getBuffer(RenderTypes.BlockOverlay);
        Color finalColor = color;
        coords.forEach((blockPos, blockState) -> {
            poseStack.pushPose();
            poseStack.translate((float)blockPos.getX(), (float)blockPos.getY(), (float)blockPos.getZ());
            poseStack.translate(-0.005f, -0.005f, -0.005f);
            poseStack.scale(1.01f, 1.01f, 1.01f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            Matrix4f positionMatrix = poseStack.last().pose();
            BlockOverlayRender.render(positionMatrix, builder, blockPos, finalColor);
            poseStack.popPose();
        });
        poseStack.popPose();
        buffer.endBatch(RenderTypes.BlockOverlay);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static void render(Matrix4f matrix, VertexConsumer builder, BlockPos pos, Color color) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = 0.125f;
        float startX = 0.0f;
        float startY = 0.0f;
        float startZ = -1.0f;
        float endX = 1.0f;
        float endY = 1.0f;
        float endZ = 0.0f;
        builder.vertex(matrix, startX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, startZ).color(red, green, blue, alpha).endVertex();
    }
}

