/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.client.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.creeperhost.equivalentexchange.client.renders.RenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class EntitySpriteRender<ENTITY extends Entity>
extends EntityRenderer<ENTITY> {
    private final ResourceLocation texture;

    public EntitySpriteRender(EntityRendererProvider.Context context, ResourceLocation texture) {
        super(context);
        this.texture = texture;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ENTITY entity) {
        return this.texture;
    }

    public void render(@NotNull ENTITY entity, float entityYaw, float partialTick, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light) {
        matrix.pushPose();
        matrix.mulPose(this.entityRenderDispatcher.cameraOrientation());
        matrix.scale(0.5f, 0.5f, 0.5f);
        VertexConsumer builder = renderer.getBuffer(RenderTypes.SPRITE_RENDERER.apply(this.getTextureLocation(entity)));
        Matrix4f matrix4f = matrix.last().pose();
        builder.vertex(matrix4f, -1.0f, -1.0f, 0.0f).uv(1.0f, 1.0f).endVertex();
        builder.vertex(matrix4f, -1.0f, 1.0f, 0.0f).uv(1.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, 1.0f, 1.0f, 0.0f).uv(0.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, 1.0f, -1.0f, 0.0f).uv(0.0f, 1.0f).endVertex();
        matrix.popPose();
    }
}

