/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.client.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class NovaRenderer<T extends PrimedTnt>
extends EntityRenderer<T> {
    private final Supplier<BlockState> supplier;
    private final BlockRenderDispatcher blockRenderer;

    public NovaRenderer(EntityRendererProvider.Context context, Supplier<BlockState> stateSupplier) {
        super(context);
        this.supplier = stateSupplier;
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public void render(T entity, float f, float partialTick, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light) {
        poseStack.pushPose();
        poseStack.translate(0.0, 0.5, 0.0);
        int fuse = entity.getFuse();
        if ((float)fuse - partialTick + 1.0f < 10.0f) {
            float h = 1.0f - ((float)fuse - partialTick + 1.0f) / 10.0f;
            h = Mth.clamp((float)h, (float)0.0f, (float)1.0f);
            h *= h;
            h *= h;
            float f1 = 1.0f + h * 0.3f;
            poseStack.scale(f1, f1, f1);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        poseStack.translate(-0.5, -0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        TntMinecartRenderer.renderWhiteSolidBlock((BlockRenderDispatcher)this.blockRenderer, (BlockState)Blocks.TNT.defaultBlockState(), (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)light, (fuse / 5 % 2 == 0 ? 1 : 0) != 0);
        TntMinecartRenderer.renderWhiteSolidBlock((BlockRenderDispatcher)this.blockRenderer, (BlockState)this.supplier.get(), (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)light, (fuse / 5 % 2 == 0 ? 1 : 0) != 0);
        poseStack.popPose();
        super.render(entity, f, partialTick, poseStack, multiBufferSource, light);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

