/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.client.screens;

import java.util.Locale;
import net.creeperhost.equivalentexchange.api.EmcFormatter;
import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.creeperhost.equivalentexchange.api.IEmcScreen;
import net.creeperhost.equivalentexchange.containers.ContainerTransmutationTable;
import net.creeperhost.equivalentexchange.impl.TransmutationTableHandler;
import net.creeperhost.equivalentexchange.network.packets.UpdateTransmutationFilter;
import net.creeperhost.equivalentexchange.network.packets.UpdateTransmutationPage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class ScreenTransmutationTable
extends AbstractContainerScreen<ContainerTransmutationTable>
implements IEmcScreen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("equivalentexchange", "textures/gui/transmutation_table.png");
    private final Player player;
    private EditBox searchBox;
    private Button leftButton;
    private Button rightButton;
    private int page = 0;

    public ScreenTransmutationTable(ContainerTransmutationTable abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.player = inventory.player;
        this.imageWidth = 228;
        this.imageHeight = 196;
        this.page = 0;
    }

    protected void init() {
        super.init();
        this.searchBox = new EditBox(this.font, this.leftPos + 88, this.topPos + 8, 45, 10, (Component)Component.literal((String)""));
        this.searchBox.setValue("");
        this.leftButton = Button.builder((Component)Component.literal((String)"<"), button -> this.changePage(this.page - 1)).pos(this.leftPos + 135, this.topPos + 100).size(15, 15).build();
        this.rightButton = Button.builder((Component)Component.literal((String)">"), button -> this.changePage(this.page + 1)).pos(this.leftPos + 180, this.topPos + 100).size(15, 15).build();
        this.addRenderableWidget((GuiEventListener)this.leftButton);
        this.addRenderableWidget((GuiEventListener)this.rightButton);
    }

    public void changePage(int page) {
        if (page >= 0) {
            this.page = page;
            new UpdateTransmutationPage(page).sendToServer();
        }
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, i, j, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int i, int j) {
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.searchBox.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.minecraft != null && this.minecraft.player != null) {
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"EMC:"), this.leftPos + 6, this.topPos + 88, 0x404040, false);
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)EmcFormatter.tidyValue(EquivalentExchangeAPI.getStorageHandler().getEmcValueFor((Player)this.minecraft.player))), this.leftPos + 6, this.topPos + 100, 0x404040, false);
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("" + this.page)), this.leftPos + 162, this.topPos + 106, 0x404040, false);
            this.renderTooltip(guiGraphics, mouseX, mouseY);
            if (this.isInRect(this.leftPos + 6, this.topPos + 100, 80, 10, mouseX, mouseY)) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)("EMC: " + EmcFormatter.getFormatter().format(EquivalentExchangeAPI.getStorageHandler().getEmcValueFor((Player)this.minecraft.player)))), mouseX, mouseY);
            }
        }
    }

    public boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.isFocused()) {
            if (keyCode == 256) {
                this.searchBox.setFocused(false);
                return true;
            }
            if (this.searchBox.keyPressed(keyCode, scanCode, modifiers)) {
                this.updateFilter();
                return true;
            }
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        if (this.searchBox.isFocused()) {
            if (this.searchBox.charTyped(c, keyCode)) {
                this.updateFilter();
                return true;
            }
            return false;
        }
        return super.charTyped(c, keyCode);
    }

    public boolean mouseClicked(double x, double y, int mouseButton) {
        if (this.searchBox.isMouseOver(x, y)) {
            this.searchBox.setFocused(true);
            if (mouseButton == 1) {
                this.searchBox.setValue("");
                this.updateFilter();
            }
            return this.searchBox.mouseClicked(x, y, mouseButton);
        }
        return super.mouseClicked(x, y, mouseButton);
    }

    private void updateFilter() {
        String search = this.searchBox.getValue().toLowerCase(Locale.ROOT);
        TransmutationTableHandler.getTransmutationInventory(this.player).setFilter(search, true);
        new UpdateTransmutationFilter(search).sendToServer();
    }
}

