/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.compat;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.event.PlayerJoinedPartyTeamEvent;
import java.util.List;
import net.creeperhost.equivalentexchange.EquivalentExchange;
import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.creeperhost.equivalentexchange.api.events.EmcChangedEvent;
import net.creeperhost.equivalentexchange.api.events.KnowledgeChangedEvent;
import net.creeperhost.equivalentexchange.compat.teams.TeamsEmcStorage;
import net.creeperhost.equivalentexchange.compat.teams.TeamsKnowledgeHandler;
import net.creeperhost.equivalentexchange.impl.KnowledgeHandler;
import net.creeperhost.equivalentexchange.impl.PlayerEmcStorage;
import net.creeperhost.equivalentexchange.network.packets.PlayerEmcPacket;
import net.creeperhost.equivalentexchange.network.packets.knowledge.KnowledgePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;

public class CompatHandler {
    public static void init() {
        if (Platform.isModLoaded((String)"ftbteams")) {
            EquivalentExchange.LOGGER.info("ftb teams detected, starting teams compat");
            EquivalentExchangeAPI.iEmcStorageHandler = new TeamsEmcStorage();
            EquivalentExchangeAPI.iKnowledgeHandler = new TeamsKnowledgeHandler();
            if (Platform.getEnv() == Dist.DEDICATED_SERVER) {
                EmcChangedEvent.EMC_ADDED_EVENT.register((player, current, added, newValue) -> {
                    Team team = (Team)FTBTeamsAPI.api().getManager().getTeamForPlayerID(player.getUUID()).get();
                    team.getMembers().forEach(uuid -> {
                        ServerPlayer serverPlayer = FTBTeamsAPI.api().getManager().getServer().getPlayerList().getPlayer(uuid);
                        if (serverPlayer != null) {
                            new PlayerEmcPacket(newValue).sendTo(serverPlayer);
                        }
                    });
                });
                EmcChangedEvent.EMC_REMOVED_EVENT.register((player, current, removed, newValue) -> {
                    Team team = (Team)FTBTeamsAPI.api().getManager().getTeamForPlayerID(player.getUUID()).get();
                    team.getMembers().forEach(uuid -> {
                        ServerPlayer serverPlayer = FTBTeamsAPI.api().getManager().getServer().getPlayerList().getPlayer(uuid);
                        if (serverPlayer != null) {
                            new PlayerEmcPacket(newValue).sendTo(serverPlayer);
                        }
                    });
                });
                KnowledgeChangedEvent.KNOWLEDGE_ADDED_EVENT.register((player, stack) -> {
                    Team team = (Team)FTBTeamsAPI.api().getManager().getTeamForPlayerID(player.getUUID()).get();
                    team.getMembers().forEach(uuid -> {
                        ServerPlayer serverPlayer = FTBTeamsAPI.api().getManager().getServer().getPlayerList().getPlayer(uuid);
                        EquivalentExchange.LOGGER.info("Adding knowledge for {} to player {}", (Object)stack.getDisplayName().getString(), (Object)serverPlayer.getDisplayName().getString());
                        if (serverPlayer != null) {
                            new KnowledgePacket(EquivalentExchangeAPI.iKnowledgeHandler.getKnowledgeList(player)).sendTo(serverPlayer);
                        }
                    });
                });
                KnowledgeChangedEvent.KNOWLEDGE_REMOVED_EVENT.register((player, stack) -> {
                    Team team = (Team)FTBTeamsAPI.api().getManager().getTeamForPlayerID(player.getUUID()).get();
                    team.getMembers().forEach(uuid -> {
                        ServerPlayer serverPlayer = FTBTeamsAPI.api().getManager().getServer().getPlayerList().getPlayer(uuid);
                        if (serverPlayer != null) {
                            new KnowledgePacket(EquivalentExchangeAPI.iKnowledgeHandler.getKnowledgeList(player)).sendTo(serverPlayer);
                        }
                    });
                });
                PlayerJoinedPartyTeamEvent.PLAYER_JOINED_PARTY.register(playerJoinedPartyTeamEvent -> {
                    try {
                        ServerPlayer player = playerJoinedPartyTeamEvent.getPlayer();
                        Team lastTeam = playerJoinedPartyTeamEvent.getPreviousTeam();
                        if (lastTeam.isPlayerTeam()) {
                            double lastEMC = EquivalentExchangeAPI.getStorageHandler().getEmcValueFor(lastTeam.getTeamId());
                            EquivalentExchangeAPI.getStorageHandler().addEmcFor((Player)player, lastEMC);
                            EquivalentExchangeAPI.getStorageHandler().setEmcValueFor(lastTeam.getTeamId(), 0.0);
                            List<ItemStack> old = EquivalentExchangeAPI.getKnowledgeHandler().getKnowledgeList(lastTeam.getTeamId());
                            List<ItemStack> list = EquivalentExchangeAPI.getKnowledgeHandler().getKnowledgeList((Player)player);
                            for (ItemStack itemStack : old) {
                                if (list.contains(itemStack)) continue;
                                EquivalentExchangeAPI.getKnowledgeHandler().addKnowledge((Player)player, itemStack);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        } else {
            EquivalentExchangeAPI.iEmcStorageHandler = new PlayerEmcStorage();
            EquivalentExchangeAPI.iKnowledgeHandler = new KnowledgeHandler();
            if (Platform.getEnv() == Dist.DEDICATED_SERVER) {
                EmcChangedEvent.EMC_ADDED_EVENT.register((player, current, added, newValue) -> {
                    if (!player.level().isClientSide()) {
                        new PlayerEmcPacket(newValue).sendTo((ServerPlayer)player);
                    }
                });
                EmcChangedEvent.EMC_REMOVED_EVENT.register((player, current, removed, newValue) -> {
                    if (!player.level().isClientSide()) {
                        new PlayerEmcPacket(newValue).sendTo((ServerPlayer)player);
                    }
                });
                KnowledgeChangedEvent.KNOWLEDGE_ADDED_EVENT.register((player, stack) -> {
                    if (!player.level().isClientSide()) {
                        new KnowledgePacket(EquivalentExchangeAPI.iKnowledgeHandler.getKnowledgeList(player)).sendTo((ServerPlayer)player);
                    }
                });
                KnowledgeChangedEvent.KNOWLEDGE_REMOVED_EVENT.register((player, stack) -> {
                    if (!player.level().isClientSide()) {
                        new KnowledgePacket(EquivalentExchangeAPI.iKnowledgeHandler.getKnowledgeList(player)).sendTo((ServerPlayer)player);
                    }
                });
            }
        }
    }
}

