/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.creeperhost.equivalentexchange.api.recipe.InWorldTransmutation;
import net.creeperhost.equivalentexchange.compat.jei.EERecipeTypes;
import net.creeperhost.equivalentexchange.compat.jei.InWorldTransmutationCategory;
import net.creeperhost.equivalentexchange.init.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class EEJeiPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("equivalentexchange", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new InWorldTransmutationCategory(jeiHelpers.getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.PHILOSOPHERS_STONE.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.PHILOSOPHERS_STONE.get()), new RecipeType[]{EERecipeTypes.TRANSMUTATION_RECIPE_TYPE});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(EERecipeTypes.TRANSMUTATION_RECIPE_TYPE, this.getTransmutationJEIList());
    }

    public List<InWorldTransmutation> getTransmutationJEIList() {
        ArrayList<InWorldTransmutation> list = new ArrayList<InWorldTransmutation>();
        for (InWorldTransmutation inWorldTransmutationRecipe : EquivalentExchangeAPI.IN_WORLD_TRANSMUTATION_RECIPES) {
            list.add(inWorldTransmutationRecipe);
            if (inWorldTransmutationRecipe.getAltResult() == null) continue;
            list.add(new InWorldTransmutation(inWorldTransmutationRecipe.getInput(), inWorldTransmutationRecipe.getAltResult(), inWorldTransmutationRecipe.getResult()));
        }
        return list;
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }
}

