/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.compat.teams;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.UUID;
import net.creeperhost.equivalentexchange.EquivalentExchange;
import net.creeperhost.equivalentexchange.api.IEmcStorageHandler;
import net.creeperhost.equivalentexchange.api.events.EmcChangedEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;

public class TeamsEmcStorage
implements IEmcStorageHandler {
    private static final HashMap<String, Double> STORED_EMC = new HashMap();

    @Override
    public Path getSavePath(Player player) {
        return FTBTeamsAPI.api().getManager().getServer().getWorldPath(LevelResource.ROOT).resolve("ftbteams/emc/").resolve(this.getPlayerTeam(player).getTeamId().toString() + "_emc.dat");
    }

    private Team getPlayerTeam(Player player) {
        if (player.level().isClientSide()) {
            return FTBTeamsAPI.api().getClientManager().selfTeam();
        }
        return (Team)FTBTeamsAPI.api().getManager().getTeamForPlayerID(player.getUUID()).get();
    }

    @Override
    public double getEmcValueFor(Player player) {
        if (!STORED_EMC.containsKey(this.getPlayerTeam(player).getTeamId().toString())) {
            STORED_EMC.put(this.getPlayerTeam(player).getTeamId().toString(), 0.0);
        }
        return STORED_EMC.get(this.getPlayerTeam(player).getTeamId().toString());
    }

    @Override
    public double getEmcValueFor(UUID uuid) {
        if (!STORED_EMC.containsKey(uuid.toString())) {
            STORED_EMC.put(uuid.toString(), 0.0);
        }
        return STORED_EMC.get(uuid.toString());
    }

    @Override
    public void setEmcValueFor(Player player, double value) {
        STORED_EMC.put(this.getPlayerTeam(player).getTeamId().toString(), value);
    }

    @Override
    public void setEmcValueFor(UUID uuid, double value) {
        STORED_EMC.put(uuid.toString(), value);
    }

    @Override
    public void addEmcFor(UUID uuid, double value) {
        double currentValue = this.getEmcValueFor(uuid);
        double newValue = currentValue + value;
        this.setEmcValueFor(uuid, newValue);
    }

    @Override
    public void addEmcFor(Player player, double value) {
        double currentValue = this.getEmcValueFor(player);
        double newValue = currentValue + value;
        this.setEmcValueFor(player, newValue);
        ((EmcChangedEvent.Added)EmcChangedEvent.EMC_ADDED_EVENT.invoker()).added(player, currentValue, value, newValue);
    }

    @Override
    public double removeEmcFor(Player player, double value) {
        double currentValue = this.getEmcValueFor(player);
        if (currentValue >= value) {
            double newValue = currentValue - value;
            this.setEmcValueFor(player, newValue);
            ((EmcChangedEvent.Removed)EmcChangedEvent.EMC_REMOVED_EVENT.invoker()).removed(player, currentValue, value, newValue);
            return newValue;
        }
        return value;
    }

    @Override
    public double removeEmcFor(UUID uuid, double value) {
        double currentValue = this.getEmcValueFor(uuid);
        if (currentValue >= value) {
            double newValue = currentValue - value;
            this.setEmcValueFor(uuid, newValue);
            return newValue;
        }
        return value;
    }

    @Override
    public void saveEmcToFile(Player player) {
        if (player != null && !player.level().isClientSide) {
            this.getSavePath(player).getParent().toFile().mkdirs();
            EquivalentExchange.LOGGER.info("Saving stored emc for team " + this.getPlayerTeam(player).getTeamId().toString());
            try {
                double stored = this.getEmcValueFor(player);
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.putDouble("stored", stored);
                NbtIo.write((CompoundTag)compoundTag, (Path)this.getSavePath(player));
                EquivalentExchange.LOGGER.info("Saving value {} to {}", (Object)stored, (Object)this.getSavePath(player));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void loadPlayersEmcFromFile(Player player) {
        if (player != null && !player.level().isClientSide) {
            EquivalentExchange.LOGGER.info("Loading saved emc for team " + this.getPlayerTeam(player).getTeamId().toString());
            if (!this.getSavePath(player).toFile().exists()) {
                try {
                    this.getSavePath(player).toFile().createNewFile();
                    this.saveEmcToFile(player);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                CompoundTag compoundTag = NbtIo.read((Path)this.getSavePath(player));
                if (compoundTag == null) {
                    EquivalentExchange.LOGGER.error("unable to load " + this.getSavePath(player));
                    return;
                }
                double value = compoundTag.getDouble("stored");
                EquivalentExchange.LOGGER.info("Loaded value {} for player {}", (Object)value, (Object)player.getDisplayName().getString());
                STORED_EMC.put(this.getPlayerTeam(player).getTeamId().toString(), value);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void clear() {
        EquivalentExchange.LOGGER.info("Cleaning up players stored emc");
        STORED_EMC.clear();
    }

    @Override
    public void onChanged(Player player, double value) {
    }
}

