/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.containers;

import net.creeperhost.equivalentexchange.blockentities.BlockEntityCondenser;
import net.creeperhost.equivalentexchange.containers.slots.EmcPolySlot;
import net.creeperhost.equivalentexchange.containers.slots.GhostSlot;
import net.creeperhost.equivalentexchange.init.ModContainers;
import net.creeperhost.polylib.client.modulargui.lib.container.DataSync;
import net.creeperhost.polylib.client.modulargui.lib.container.SlotGroup;
import net.creeperhost.polylib.containers.DataManagerContainer;
import net.creeperhost.polylib.containers.ModularGuiContainerMenu;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.data.serializable.DoubleData;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ContainerCondenser
extends ModularGuiContainerMenu
implements DataManagerContainer {
    public BlockEntityCondenser blockEntity;
    public final SlotGroup main = this.createSlotGroup(0, new int[]{1, 3});
    public final SlotGroup hotBar = this.createSlotGroup(0, new int[]{1, 3});
    public final SlotGroup armor = this.createSlotGroup(1, new int[]{3, 0});
    public final SlotGroup offhand = this.createSlotGroup(2, new int[]{3, 0});
    public final SlotGroup chest = this.createSlotGroup(3, new int[]{1, 0, 2});
    public final SlotGroup target = this.createSlotGroup(4, new int[]{1, 0, 2});
    public final DataSync<Double> stored;
    public final DataSync<Double> targetdata;

    public ContainerCondenser(int id, Inventory playerInv, FriendlyByteBuf extraData) {
        this(id, playerInv, (BlockEntityCondenser)Minecraft.getInstance().level.getBlockEntity(extraData.readBlockPos()));
    }

    public ContainerCondenser(int id, Inventory playerInv, BlockEntityCondenser blockEntityCondenser) {
        super((MenuType)ModContainers.CONDENSER_CONTAINER.get(), id, playerInv);
        this.blockEntity = blockEntityCondenser;
        this.stored = new DataSync((ModularGuiContainerMenu)this, (AbstractDataStore)new DoubleData(), () -> (Double)this.blockEntity.storedEMC.get());
        this.targetdata = new DataSync((ModularGuiContainerMenu)this, (AbstractDataStore)new DoubleData(), () -> (Double)this.blockEntity.targetEMC.get());
        this.main.addPlayerMain(this.inventory);
        this.hotBar.addPlayerBar(this.inventory);
        this.armor.addPlayerArmor(this.inventory);
        this.offhand.addPlayerOffhand(this.inventory);
        this.chest.addSlots(91, 0, index -> new EmcPolySlot(blockEntityCondenser.getContainer(Direction.UP), (int)index));
        this.target.addSlots(1, 91, index -> new EmcPolySlot(blockEntityCondenser.getContainer(Direction.UP), (int)index));
    }

    public void clicked(int slotId, int dragType, @NotNull ClickType clickType, @NotNull Player player) {
        if (slotId >= 0 && this.getSlot(slotId) instanceof GhostSlot) {
            if (!this.getCarried().isEmpty()) {
                ItemStack stack = this.getCarried().copy();
                stack.setCount(1);
                this.setItem(slotId, 1, stack);
            } else {
                this.setItem(slotId, 1, ItemStack.EMPTY);
            }
            return;
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public <T extends BlockEntity> T getBlockEntity() {
        return (T)this.blockEntity;
    }
}

