/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.containers;

import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.creeperhost.equivalentexchange.containers.prefab.ContainerBase;
import net.creeperhost.equivalentexchange.containers.slots.EmcSlot;
import net.creeperhost.equivalentexchange.containers.slots.SlotOutput;
import net.creeperhost.equivalentexchange.impl.TransmutationTableHandler;
import net.creeperhost.equivalentexchange.init.ModContainers;
import net.creeperhost.equivalentexchange.inventory.TransmutationInventory;
import net.creeperhost.equivalentexchange.network.packets.PlayerEmcPacket;
import net.creeperhost.equivalentexchange.network.packets.TransmutationInventoryPacket;
import net.creeperhost.equivalentexchange.network.packets.knowledge.KnowledgePacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ContainerTransmutationTable
extends ContainerBase {
    TransmutationInventory transmutationInventory;

    public ContainerTransmutationTable(int id, Inventory playerInv, FriendlyByteBuf extraData) {
        this(id, playerInv);
    }

    public ContainerTransmutationTable(int id, Inventory playerInv) {
        super((MenuType)ModContainers.TRANSMUTATION_TABLE_CONTAINER.get(), id);
        Player player = playerInv.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.transmutationInventory = TransmutationTableHandler.getTransmutationInventory(playerInv.player);
            this.transmutationInventory.resetPage();
            this.transmutationInventory.resetFilter();
            this.transmutationInventory.updateInventory();
            new PlayerEmcPacket(EquivalentExchangeAPI.getStorageHandler().getEmcValueFor((Player)serverPlayer)).sendTo(serverPlayer);
            new KnowledgePacket(EquivalentExchangeAPI.getKnowledgeHandler().getKnowledgeList((Player)serverPlayer)).sendTo(serverPlayer);
            new TransmutationInventoryPacket(this.transmutationInventory.serializeNBT()).sendTo(serverPlayer);
        } else {
            this.transmutationInventory = TransmutationTableHandler.getTransmutationInventory(playerInv.player);
            this.transmutationInventory.resetPage();
            this.transmutationInventory.resetFilter();
            this.transmutationInventory.updateInventory();
        }
        this.addSlot(new EmcSlot(this.transmutationInventory, 0, 107, 97));
        this.addSlot(new EmcSlot(this.transmutationInventory, 1, 89, 97));
        this.addSlot(new EmcSlot(this.transmutationInventory, 2, 158, 49));
        this.addSlot(new EmcSlot(this.transmutationInventory, 3, 43, 23));
        this.addSlot(new EmcSlot(this.transmutationInventory, 4, 34, 41));
        this.addSlot(new EmcSlot(this.transmutationInventory, 5, 52, 41));
        this.addSlot(new EmcSlot(this.transmutationInventory, 6, 16, 50));
        this.addSlot(new EmcSlot(this.transmutationInventory, 7, 70, 50));
        this.addSlot(new EmcSlot(this.transmutationInventory, 8, 34, 59));
        this.addSlot(new EmcSlot(this.transmutationInventory, 9, 52, 59));
        this.addSlot(new EmcSlot(this.transmutationInventory, 10, 43, 77));
        this.addSlot(new SlotOutput(this.transmutationInventory, 11, 158, 9));
        this.addSlot(new SlotOutput(this.transmutationInventory, 12, 176, 13));
        this.addSlot(new SlotOutput(this.transmutationInventory, 13, 193, 30));
        this.addSlot(new SlotOutput(this.transmutationInventory, 14, 199, 50));
        this.addSlot(new SlotOutput(this.transmutationInventory, 15, 193, 70));
        this.addSlot(new SlotOutput(this.transmutationInventory, 16, 176, 87));
        this.addSlot(new SlotOutput(this.transmutationInventory, 17, 158, 91));
        this.addSlot(new SlotOutput(this.transmutationInventory, 18, 140, 87));
        this.addSlot(new SlotOutput(this.transmutationInventory, 19, 123, 70));
        this.addSlot(new SlotOutput(this.transmutationInventory, 20, 116, 50));
        this.addSlot(new SlotOutput(this.transmutationInventory, 21, 123, 30));
        this.addSlot(new SlotOutput(this.transmutationInventory, 22, 140, 13));
        this.addSlot(new SlotOutput(this.transmutationInventory, 23, 158, 31));
        this.addSlot(new SlotOutput(this.transmutationInventory, 24, 177, 50));
        this.addSlot(new SlotOutput(this.transmutationInventory, 25, 158, 69));
        this.addSlot(new SlotOutput(this.transmutationInventory, 26, 139, 50));
        for (int l = 0; l < 3; ++l) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInv, k + l * 9 + 9, 35 + k * 18, l * 18 + 117));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)playerInv, i1, 35 + i1 * 18, 175));
        }
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        TransmutationTableHandler.updateInventory(player, this.transmutationInventory);
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    @Override
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotIndex) {
        Slot slot;
        ItemStack stack;
        if (player.level().isClientSide) {
            return ItemStack.EMPTY;
        }
        int burnID = 0;
        if (slotIndex >= 27 && slotIndex <= 62 && !(stack = (slot = (Slot)this.slots.get(slotIndex)).getItem()).isEmpty() && EquivalentExchangeAPI.hasEmcValue(stack)) {
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            ((Slot)this.slots.get(burnID)).set(stack);
            slot.set(ItemStack.EMPTY);
            return ItemStack.EMPTY;
        }
        if (slotIndex >= 11 && slotIndex <= 26) {
            ItemStack stack2 = ((Slot)this.slots.get(slotIndex)).getItem().copy();
            double playersEMC = EquivalentExchangeAPI.getStorageHandler().getEmcValueFor(player);
            double itemEMCValue = EquivalentExchangeAPI.getEmcValue(stack2);
            int affordableAmount = (int)(playersEMC / itemEMCValue);
            int extractableAmount = Math.min(affordableAmount, stack2.getMaxStackSize());
            stack2.setCount(extractableAmount);
            player.addItem(stack2);
            EquivalentExchangeAPI.getStorageHandler().removeEmcFor(player, itemEMCValue * (double)extractableAmount);
            this.transmutationInventory.updateInventory();
        }
        return ItemStack.EMPTY;
    }

    public TransmutationInventory getTransmutationInventory() {
        return this.transmutationInventory;
    }
}

