/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.dynemc;

import com.google.common.base.Stopwatch;
import dev.architectury.event.events.common.LifecycleEvent;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.creeperhost.equivalentexchange.EquivalentExchange;
import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.creeperhost.equivalentexchange.api.IEmcRecipeParser;
import net.creeperhost.equivalentexchange.api.events.EmcRegisterEvent;
import net.creeperhost.equivalentexchange.dynemc.json.DynEmcMapper;
import net.creeperhost.equivalentexchange.dynemc.json.ProjecteEmcMapper;
import net.creeperhost.equivalentexchange.dynemc.recipe.VanillaRecipeParser;
import net.creeperhost.equivalentexchange.network.packets.EmcValuesPacket;
import net.creeperhost.polylib.helpers.ItemTagHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class DynamicEmc {
    public static void init() {
        EquivalentExchangeAPI.UpdatingValues = true;
        EquivalentExchangeAPI.registerParser(RecipeType.CRAFTING, new VanillaRecipeParser());
        EquivalentExchangeAPI.registerParser(RecipeType.SMELTING, new VanillaRecipeParser());
        EquivalentExchangeAPI.registerParser(RecipeType.BLASTING, new VanillaRecipeParser());
        EquivalentExchangeAPI.registerParser(RecipeType.CAMPFIRE_COOKING, new VanillaRecipeParser());
        EquivalentExchangeAPI.registerParser(RecipeType.SMOKING, new VanillaRecipeParser());
        EquivalentExchangeAPI.registerParser(RecipeType.STONECUTTING, new VanillaRecipeParser());
        LifecycleEvent.SERVER_STARTED.register(instance -> {
            ((EmcRegisterEvent.PreEvent)EmcRegisterEvent.EMC_PRE_START.invoker()).preStart(instance.getResourceManager());
            DynEmcMapper.init(instance.getResourceManager());
            if (EquivalentExchange.CONFIG_DATA.ProjectECompat) {
                ProjecteEmcMapper.init(instance.getResourceManager());
            }
            if (EquivalentExchange.CONFIG_DATA.UseRecipeManager) {
                CompletableFuture.runAsync(() -> {
                    try {
                        Thread.sleep(5000L);
                        RecipeManager recipeManager = instance.getRecipeManager();
                        Stopwatch stopwatch = Stopwatch.createStarted();
                        AtomicInteger retries = new AtomicInteger(10);
                        while (retries.get() > 0) {
                            try {
                                BuiltInRegistries.RECIPE_TYPE.forEach(recipeType -> {
                                    RegistryAccess.Frozen registryAccess = RegistryAccess.EMPTY;
                                    String resourceLocation = recipeType.toString();
                                    if (recipeType != null) {
                                        IEmcRecipeParser parser = EquivalentExchangeAPI.PARSERS.get(recipeType);
                                        if (parser == null) {
                                            if (EquivalentExchange.CONFIG_DATA.DEBUG_PRINT) {
                                                EquivalentExchange.LOGGER.error("Unable to find parser for {} Skipping", (Object)recipeType.toString());
                                            }
                                        } else {
                                            if (EquivalentExchange.CONFIG_DATA.DEBUG_PRINT) {
                                                EquivalentExchange.LOGGER.info("Start set values for RecipeType: {}", (Object)resourceLocation);
                                            }
                                            Set<RecipeHolder<?>> recipes = DynamicEmc.findRecipesByType(recipeType, recipeManager);
                                            recipes.forEach(arg_0 -> DynamicEmc.lambda$init$0(parser, (RegistryAccess)registryAccess, arg_0));
                                        }
                                    }
                                });
                                retries.getAndDecrement();
                                Thread.sleep(1000L);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ((EmcRegisterEvent.PostEvent)EmcRegisterEvent.EMC_POST_START.invoker()).postStart(instance.getResourceManager());
                        EquivalentExchangeAPI.UpdatingValues = false;
                        new EmcValuesPacket(EquivalentExchangeAPI.EMC_VALUES).sendToAll((MinecraftServer)instance);
                        EquivalentExchange.LOGGER.info("Finished generating values for recipes after {}ms", (Object)stopwatch.elapsed().toMillis());
                        stopwatch.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        });
    }

    public static void generateForItem(String resourceLocation, double value) {
        try {
            ItemStack stack;
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)resourceLocation));
            if (item != null && !(stack = new ItemStack((ItemLike)item)).isEmpty()) {
                EquivalentExchangeAPI.setEmcValue(stack, value);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void generateForTag(String resourceLocation, double value) {
        ItemTagHelper.getValues((String)resourceLocation).forEach(itemHolder -> EquivalentExchangeAPI.setEmcValue(new ItemStack((ItemLike)itemHolder.value()), value));
    }

    private static Set<RecipeHolder<?>> findRecipesByType(RecipeType<?> typeIn, RecipeManager recipeManager) {
        return recipeManager.getRecipes().stream().filter(recipe -> recipe.value().getType() == typeIn).collect(Collectors.toSet());
    }

    private static /* synthetic */ void lambda$init$0(IEmcRecipeParser parser, RegistryAccess registryAccess, RecipeHolder recipe) {
        parser.setValueForRecipe(recipe.value(), registryAccess);
    }
}

