/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.dynemc.json;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.creeperhost.equivalentexchange.EquivalentExchange;
import net.creeperhost.equivalentexchange.dynemc.DynamicEmc;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class DynEmcMapper {
    public static void init(ResourceManager resourceManager) {
        String folderName = "ee_emc";
        String fileType = ".json";
        EquivalentExchange.LOGGER.info("DynEmcMapper loaded");
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (Map.Entry entry : resourceManager.listResourceStacks(folderName, n -> n.getPath().endsWith(fileType)).entrySet()) {
            ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
            EquivalentExchange.LOGGER.info("found file {}", (Object)resourceLocation);
            try {
                for (Resource resource : (List)entry.getValue()) {
                    try {
                        BufferedReader reader = resource.openAsReader();
                        JsonElement json = JsonParser.parseReader((Reader)reader);
                        JsonObject object = json.getAsJsonObject().getAsJsonObject("values");
                        object.entrySet().forEach(stringJsonElementEntry -> {
                            String key = (String)stringJsonElementEntry.getKey();
                            double value = ((JsonElement)stringJsonElementEntry.getValue()).getAsDouble();
                            if (key.startsWith("#")) {
                                DynamicEmc.generateForTag(key.substring(1), value);
                                EquivalentExchange.LOGGER.info("Registering tag {} with value {}", (Object)key, (Object)value);
                            } else {
                                DynamicEmc.generateForItem(key, value);
                                EquivalentExchange.LOGGER.info("Registering item {} with value {}", (Object)key, (Object)value);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        EquivalentExchange.LOGGER.info("Finished loading emc jsons after " + stopwatch.elapsed().toMillis() + "ms");
        stopwatch.stop();
    }
}

