/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.dynemc.recipe;

import java.util.ArrayList;
import java.util.List;
import net.creeperhost.equivalentexchange.EquivalentExchange;
import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.creeperhost.equivalentexchange.api.EquivalentExchangeTags;
import net.creeperhost.equivalentexchange.api.IEmcRecipeParser;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class VanillaRecipeParser
implements IEmcRecipeParser {
    @Override
    public void setValueForRecipe(Recipe<?> recipe, RegistryAccess registryAccess) {
        if (recipe.isSpecial()) {
            if (EquivalentExchange.CONFIG_DATA.DEBUG_PRINT) {
                EquivalentExchange.LOGGER.info("Unable to parse recipe {} due to it being special", (Object)recipe.getSerializer().toString());
            }
            return;
        }
        if (recipe.isIncomplete()) {
            if (EquivalentExchange.CONFIG_DATA.DEBUG_PRINT) {
                EquivalentExchange.LOGGER.info("Unable to parse recipe {} due to it being incomplete", (Object)recipe.getSerializer().toString());
            }
            return;
        }
        ItemStack output = recipe.getResultItem(registryAccess).copy();
        if (output.isEmpty()) {
            if (EquivalentExchange.CONFIG_DATA.DEBUG_PRINT) {
                EquivalentExchange.LOGGER.info("Unable to parse recipe {} due to output being empty", (Object)recipe.getSerializer().toString());
            }
            return;
        }
        if (EquivalentExchangeTags.isBlacklisted(output)) {
            if (EquivalentExchange.CONFIG_DATA.DEBUG_PRINT) {
                EquivalentExchange.LOGGER.info("tried to add emc value to blacklisted item skipping {}", (Object)output.getDisplayName().getString());
            }
            return;
        }
        if (EquivalentExchangeAPI.hasEmcValue(output)) {
            if (EquivalentExchange.CONFIG_DATA.DEBUG_PRINT) {
                EquivalentExchange.LOGGER.info("{} already has emc value skipping", (Object)output.getDisplayName().getString());
            }
            return;
        }
        if (EquivalentExchange.CONFIG_DATA.DEBUG_PRINT) {
            EquivalentExchange.LOGGER.info("Recipe Group {} {}", (Object)recipe.getGroup(), (Object)recipe.getType().toString());
        }
        ArrayList<ItemStack> validRecipeItems = new ArrayList<ItemStack>();
        for (Ingredient ingredient2 : recipe.getIngredients()) {
            ItemStack[] slot = ingredient2.getItems();
            ItemStack valid = this.parseArray(slot, false);
            if (!valid.is(Items.BARRIER)) {
                validRecipeItems.add(valid);
                continue;
            }
            if (!EquivalentExchange.CONFIG_DATA.DEBUG_PRINT) continue;
            EquivalentExchange.LOGGER.info("Unable to find an item with an emc value for one of the input slots for recipes {}", (Object)output.getDisplayName().getString());
        }
        if (!validRecipeItems.isEmpty()) {
            if ((long)validRecipeItems.size() < recipe.getIngredients().stream().filter(ingredient -> !ingredient.isEmpty()).count()) {
                if (EquivalentExchange.CONFIG_DATA.DEBUG_PRINT) {
                    EquivalentExchange.LOGGER.info("Unable to set emc value on {} as validRecipeItems has less items than recipe size", (Object)output.getDisplayName().getString());
                }
                return;
            }
            double total = this.math(validRecipeItems);
            if (total > 0.0) {
                double value = total;
                if (output.getCount() > 1) {
                    if (EquivalentExchange.CONFIG_DATA.DEBUG_PRINT) {
                        EquivalentExchange.LOGGER.info("Count for {} is more than 1, calculating value for total {}", (Object)output.getDisplayName().getString(), (Object)total);
                    }
                    value = total / (double)output.getCount();
                }
                if (EquivalentExchange.CONFIG_DATA.DEBUG_PRINT) {
                    EquivalentExchange.LOGGER.info("Setting {} emc to {} from VanillaRecipeParser", (Object)output.getDisplayName().getString(), (Object)value);
                }
                EquivalentExchangeAPI.setEmcValue(output, value);
            }
        }
    }

    private double math(List<ItemStack> list) {
        double value = 0.0;
        for (ItemStack itemStack : list) {
            if (itemStack.getItem().hasCraftingRemainingItem() && itemStack.is(itemStack.getItem().getCraftingRemainingItem())) {
                if (!EquivalentExchange.CONFIG_DATA.DEBUG_PRINT) continue;
                EquivalentExchange.LOGGER.info("item {} is a container item that returns itself, not adding value to total", (Object)itemStack.getDisplayName().getString());
                continue;
            }
            if (itemStack.isEmpty()) continue;
            value += EquivalentExchangeAPI.getEmcValue(itemStack);
        }
        return value;
    }

    private ItemStack parseArray(ItemStack[] list, boolean debug) {
        boolean canBeEmpty = false;
        for (ItemStack itemStack : list) {
            if (debug) {
                EquivalentExchange.LOGGER.info(itemStack.getDisplayName().getString());
            }
            if (itemStack.isEmpty()) {
                canBeEmpty = true;
                continue;
            }
            if (!EquivalentExchangeAPI.hasEmcValue(itemStack)) continue;
            return itemStack;
        }
        if (canBeEmpty) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)Items.BARRIER);
    }
}

