/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.entities;

import net.creeperhost.equivalentexchange.entities.NoGravityProjectile;
import net.creeperhost.equivalentexchange.init.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class EntityVolcaniteProjectile
extends NoGravityProjectile {
    public EntityVolcaniteProjectile(EntityType<EntityVolcaniteProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public EntityVolcaniteProjectile(Player entity, Level level) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)ModEntities.VOLCANITE_PROJECTILE.get()), (LivingEntity)entity, level);
    }

    @Override
    public void tick() {
        Entity thrower;
        super.tick();
        if (!this.level().isClientSide() && this.isAlive() && (thrower = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)thrower;
            if (this.getY() > 128.0) {
                LevelData levelData = this.level().getLevelData();
                levelData.setRaining(false);
                this.discard();
            }
        }
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        Entity entity;
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide() && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            BlockPos hitPos = blockHitResult.getBlockPos();
            Direction sideHit = blockHitResult.getDirection();
            this.level().setBlock(hitPos.relative(sideHit, 1), Blocks.LAVA.defaultBlockState(), 3);
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity entity;
        super.onHitEntity(entityHitResult);
        if (!this.level().isClientSide() && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Entity hit = entityHitResult.getEntity();
            hit.setSecondsOnFire(5);
            hit.hurt(this.level().damageSources().inFire(), 5.0f);
        }
    }

    protected void onHit(@NotNull HitResult result) {
        super.onHit(result);
        this.discard();
    }

    protected void defineSynchedData() {
    }

    public boolean ignoreExplosion(@NotNull Explosion explosion) {
        return true;
    }
}

