/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.equivalentexchange.EquivalentExchange;
import net.creeperhost.equivalentexchange.inventory.AlchemicalBagInventory;
import net.creeperhost.equivalentexchange.types.BagTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;

public class AlchemicalBagHandler {
    private static final HashMap<String, HashMap<BagTypes, AlchemicalBagInventory>> INVENTORIES = new HashMap();

    public static HashMap<BagTypes, AlchemicalBagInventory> getBagInventories(Player player) {
        if (!INVENTORIES.containsKey(player.getUUID().toString())) {
            HashMap<BagTypes, AlchemicalBagInventory> map = new HashMap<BagTypes, AlchemicalBagInventory>();
            for (BagTypes value : BagTypes.values()) {
                map.put(value, new AlchemicalBagInventory(player));
            }
            INVENTORIES.put(player.getUUID().toString(), map);
        }
        return INVENTORIES.get(player.getUUID().toString());
    }

    public static AlchemicalBagInventory getInventory(Player player, BagTypes bagType) {
        return AlchemicalBagHandler.getBagInventories(player).get((Object)bagType);
    }

    public static void updateInventory(Player player, AlchemicalBagInventory alchemicalBagInventory, BagTypes bagTypes) {
        INVENTORIES.get(player.getUUID().toString()).put(bagTypes, alchemicalBagInventory);
    }

    public static void loadPlayersBagInventory(Player player, File file) {
        CompletableFuture.runAsync(() -> {
            if (player != null && !player.level().isClientSide && file != null && file.exists()) {
                try {
                    CompoundTag compoundTag = NbtIo.read((Path)file.toPath());
                    if (compoundTag == null) {
                        EquivalentExchange.LOGGER.error("unable to load file " + file.getAbsolutePath());
                        return;
                    }
                    HashMap<BagTypes, AlchemicalBagInventory> map = new HashMap<BagTypes, AlchemicalBagInventory>();
                    for (BagTypes value : BagTypes.values()) {
                        AlchemicalBagInventory alchemicalBagInventory = new AlchemicalBagInventory(player);
                        CompoundTag compoundTag1 = compoundTag.getCompound(value.getName());
                        alchemicalBagInventory.deserializeNBT(compoundTag1);
                        map.put(value, alchemicalBagInventory);
                    }
                    EquivalentExchange.LOGGER.info("Loading alchemicalBagInventory inventory for " + player.getName().getString());
                    INVENTORIES.put(player.getUUID().toString(), map);
                }
                catch (IOException e) {
                    EquivalentExchange.LOGGER.info("Failed to load inventory for " + player.getName().getString());
                    e.printStackTrace();
                }
            }
        });
    }

    public static void savePlayersBagInventory(Player player, File file) {
        if (player != null && !player.level().isClientSide && file != null) {
            HashMap<BagTypes, AlchemicalBagInventory> map = AlchemicalBagHandler.getBagInventories(player);
            CompoundTag compoundTag = new CompoundTag();
            map.forEach((bagTypes, alchemicalBagInventory) -> compoundTag.put(bagTypes.getName(), (Tag)alchemicalBagInventory.serializeNBT()));
            try {
                EquivalentExchange.LOGGER.info("Saving bag inventory for " + player.getName().getString());
                NbtIo.write((CompoundTag)compoundTag, (Path)file.toPath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void onServerSaveEvent(ServerLevel serverLevel) {
        if (serverLevel != null && serverLevel.players() != null && !serverLevel.players().isEmpty()) {
            serverLevel.players().forEach(serverPlayer -> {
                Path transmutation_path = serverPlayer.server.getWorldPath(LevelResource.PLAYER_DATA_DIR).resolve(serverPlayer.getUUID().toString() + "_alchemical_bag.dat");
                AlchemicalBagHandler.savePlayersBagInventory((Player)serverPlayer, transmutation_path.toFile());
            });
        }
    }

    public static void onPlayerJoinEvent(ServerPlayer player) {
        Path path = player.server.getWorldPath(LevelResource.PLAYER_DATA_DIR).resolve(player.getUUID().toString() + "_alchemical_bag.dat");
        if (path.toFile().exists()) {
            EquivalentExchange.LOGGER.info("Loading bags for player {}", (Object)player.getDisplayName().getString());
            AlchemicalBagHandler.loadPlayersBagInventory((Player)player, path.toFile());
        }
    }

    public static void onServerStopEvent(MinecraftServer minecraftServer) {
        EquivalentExchange.LOGGER.info("Cleaning up players alchemical bags");
        INVENTORIES.clear();
    }
}

