/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.inventory;

import net.creeperhost.equivalentexchange.EquivalentExchange;
import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.creeperhost.equivalentexchange.api.item.IKleinStarItem;
import net.creeperhost.equivalentexchange.impl.TransmutationTableHandler;
import net.creeperhost.equivalentexchange.network.packets.knowledge.RemoveKnowledgePacket;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransmutationInventory
implements Container {
    private final NonNullList<ItemStack> items;
    @Nullable
    Player player;
    private String filter = "";
    private int page = 0;

    public TransmutationInventory(@Nullable Player player) {
        this.player = player;
        this.items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
        this.resetFilter();
        this.resetPage();
        this.updateInventory();
        this.setChanged();
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return false;
    }

    @NotNull
    public ItemStack getItem(int i) {
        return (ItemStack)this.items.get(i);
    }

    @NotNull
    public ItemStack removeItem(int i, int j) {
        ItemStack itemStack = ContainerHelper.removeItem(this.items, (int)i, (int)j);
        if (i >= 11 && i <= 26 && !this.player.level().isClientSide && EquivalentExchangeAPI.hasEmcValue(itemStack)) {
            EquivalentExchangeAPI.getStorageHandler().removeEmcFor(this.player, EquivalentExchangeAPI.getEmcValue(itemStack) * (double)j);
        }
        if (!itemStack.isEmpty()) {
            this.updateInventory();
        }
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int i) {
        ItemStack itemStack = (ItemStack)this.items.get(i);
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.items.set(i, (Object)ItemStack.EMPTY);
        return itemStack;
    }

    public void setItem(int i, @NotNull ItemStack itemStack) {
        if (this.player == null) {
            return;
        }
        boolean client = this.player.level().isClientSide();
        if (!client && !EquivalentExchangeAPI.hasEmcValue(itemStack)) {
            EquivalentExchange.LOGGER.error("Player tried adding item {} to transmutation inventory with no emc value", (Object)itemStack);
            return;
        }
        if (i != 0) {
            this.items.set(i, (Object)itemStack);
        }
        if (!client) {
            if (i == 0) {
                if (!this.getItem(i).isEmpty()) {
                    EquivalentExchange.LOGGER.error("Item stuck in burn slot {} with emc value {}", (Object)this.getItem(i).getDisplayName().getString(), (Object)EquivalentExchangeAPI.getEmcValue(itemStack));
                }
                EquivalentExchangeAPI.getKnowledgeHandler().addKnowledge(this.player, new ItemStack((ItemLike)itemStack.getItem()));
                double value = EquivalentExchangeAPI.getEmcValue(itemStack) * (double)itemStack.getCount();
                Item item = itemStack.getItem();
                if (item instanceof IKleinStarItem) {
                    IKleinStarItem kleinStar = (IKleinStarItem)item;
                    value += kleinStar.getKleinStarStored(itemStack);
                }
                EquivalentExchangeAPI.getStorageHandler().addEmcFor(this.player, value);
            }
            if (i == 1) {
                EquivalentExchangeAPI.getKnowledgeHandler().removeKnowledge(this.player, itemStack);
                new RemoveKnowledgePacket(itemStack).sendTo((ServerPlayer)this.player);
            } else if (i >= 2 && i <= 10) {
                Item item = itemStack.getItem();
                if (item instanceof IKleinStarItem) {
                    IKleinStarItem kleinStar = (IKleinStarItem)item;
                    double starCurrent = kleinStar.getKleinStarStored(itemStack);
                    double playerCurrent = EquivalentExchangeAPI.getStorageHandler().getEmcValueFor(this.player);
                    if (i != 2 && starCurrent < kleinStar.getKleinStarMaxStorage(itemStack)) {
                        double starMax = kleinStar.getKleinStarMaxStorage(itemStack);
                        double starFree = starMax - starCurrent;
                        double starAdded = Math.min(playerCurrent, starFree);
                        kleinStar.setKleinStarEmc(itemStack, starCurrent + starAdded);
                        EquivalentExchangeAPI.getStorageHandler().removeEmcFor(this.player, starAdded);
                    } else if (i == 2 && starCurrent > 0.0) {
                        kleinStar.setKleinStarEmc(itemStack, 0.0);
                        EquivalentExchangeAPI.getStorageHandler().addEmcFor(this.player, starCurrent);
                    }
                }
                if (EquivalentExchangeAPI.hasEmcValue(itemStack)) {
                    EquivalentExchangeAPI.getKnowledgeHandler().addKnowledge(this.player, new ItemStack((ItemLike)itemStack.getItem()));
                }
            }
            this.updateInventory();
        }
        this.setChanged();
    }

    public void setChanged() {
    }

    public void updateInventory() {
        if (this.player == null) {
            return;
        }
        NonNullList<ItemStack> transmutations = TransmutationTableHandler.getTransmutationContent(this.page, this.filter, this.getItem(2), this.player);
        int start = 11;
        int end = 26;
        int i = start;
        for (ItemStack transmutation : transmutations) {
            if (i > end) continue;
            this.items.set(i, (Object)transmutation.copy());
            ++i;
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            ((ItemStack)this.items.get(i)).save(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)nbtTagList);
        nbt.putInt("Size", this.items.size());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag tagList = nbt.getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.getCompound(i);
            int slot = itemTags.getInt("Slot");
            if (slot < 0 || slot >= this.items.size()) continue;
            this.items.set(slot, (Object)ItemStack.of((CompoundTag)itemTags));
        }
    }

    public void setFilter(String filter, boolean changed) {
        this.filter = filter;
        this.updateInventory();
    }

    public void resetFilter() {
        this.setFilter("", true);
    }

    public void setPage(int page) {
        this.page = page;
        this.updateInventory();
    }

    public int getPage() {
        return this.page;
    }

    public void resetPage() {
        this.setPage(0);
    }
}

