/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.items;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import net.creeperhost.equivalentexchange.containers.ContainerAlchemicalBag;
import net.creeperhost.equivalentexchange.types.BagTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemAlchemyBag
extends Item {
    BagTypes bagType;

    public ItemAlchemyBag(BagTypes bagType) {
        super(new Item.Properties().stacksTo(1));
        this.bagType = bagType;
    }

    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        if (!level.isClientSide) {
            MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)new ContainerProvider());
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(interactionHand));
    }

    public BagTypes getBagType() {
        return this.bagType;
    }

    private record ContainerProvider() implements ExtendedMenuProvider
    {
        public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player player) {
            return new ContainerAlchemicalBag(windowId, playerInventory);
        }

        @NotNull
        public Component getDisplayName() {
            return Component.literal((String)"container.alchemy_bag");
        }

        public void saveExtraData(FriendlyByteBuf buf) {
        }
    }
}

