/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.items;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.creeperhost.equivalentexchange.api.recipe.InWorldTransmutation;
import net.creeperhost.equivalentexchange.containers.PhilosophersStoneContainer;
import net.creeperhost.equivalentexchange.init.ModSounds;
import net.creeperhost.equivalentexchange.items.interfaces.IActionItem;
import net.creeperhost.equivalentexchange.items.interfaces.IChargeableItem;
import net.creeperhost.equivalentexchange.items.interfaces.IOverlayItem;
import net.creeperhost.polylib.helpers.VectorHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPhilosophersStone
extends Item
implements IActionItem,
IChargeableItem,
IOverlayItem {
    public ItemPhilosophersStone() {
        super(new Item.Properties().stacksTo(1));
        this.craftingRemainingItem = this;
    }

    @Override
    public boolean blockIgnored(BlockState blockState) {
        return blockState.isAir();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        int hitRange = 5;
        BlockHitResult hitResult = VectorHelper.getLookingAt((Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY, (int)hitRange);
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            boolean isSneaking;
            BlockPos targetPos = hitResult.getBlockPos();
            Direction targetFace = hitResult.getDirection();
            BlockState targetState = level.getBlockState(targetPos);
            BlockState result = ItemPhilosophersStone.getTransmutation(targetState, isSneaking = player.isShiftKeyDown());
            if (result == null) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            Map<BlockPos, BlockState> changes = ItemPhilosophersStone.getChanges(level, targetPos, player, targetFace, this.getCharge(itemstack));
            changes.forEach((blockPos, blockState) -> level.setBlock(blockPos, blockState, 3));
            level.playSound(player, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.TRANSMUTE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.success((Object)itemstack);
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    @Nullable
    public static BlockState getTransmutation(BlockState blockState, boolean sneaking) {
        for (InWorldTransmutation inWorldTransmutationRecipe : EquivalentExchangeAPI.IN_WORLD_TRANSMUTATION_RECIPES) {
            if (inWorldTransmutationRecipe.getInput() != blockState) continue;
            return sneaking ? inWorldTransmutationRecipe.getAltResult() : inWorldTransmutationRecipe.getResult();
        }
        return null;
    }

    public static Map<BlockPos, BlockState> getChanges(Level level, BlockPos pos, Player player, Direction sideHit, int charge) {
        boolean isSneaking;
        BlockState targeted = level.getBlockState(pos);
        @Nullable BlockState result = ItemPhilosophersStone.getTransmutation(targeted, isSneaking = player.isShiftKeyDown());
        if (result == null) {
            return Collections.emptyMap();
        }
        Stream stream = null;
        if (sideHit == Direction.UP || sideHit == Direction.DOWN) {
            stream = BlockPos.betweenClosedStream((BlockPos)pos.offset(-charge, 0, -charge), (BlockPos)pos.offset(charge, 0, charge));
        } else if (sideHit == Direction.EAST || sideHit == Direction.WEST) {
            stream = BlockPos.betweenClosedStream((BlockPos)pos.offset(0, -charge, -charge), (BlockPos)pos.offset(0, charge, charge));
        } else if (sideHit == Direction.SOUTH || sideHit == Direction.NORTH) {
            stream = BlockPos.betweenClosedStream((BlockPos)pos.offset(-charge, -charge, 0), (BlockPos)pos.offset(charge, charge, 0));
        }
        if (stream == null) {
            return Collections.emptyMap();
        }
        Object2ObjectArrayMap conversions = new Object2ObjectArrayMap();
        conversions.put(targeted, result);
        HashMap<BlockPos, BlockState> changes = new HashMap<BlockPos, BlockState>();
        Block targetBlock = targeted.getBlock();
        stream.forEach(arg_0 -> ItemPhilosophersStone.lambda$getChanges$1(level, targetBlock, (Map)conversions, isSneaking, changes, arg_0));
        return changes;
    }

    public boolean hasCraftingRemainingItem() {
        return true;
    }

    @Override
    public void onActionKeyPressed(@NotNull ItemStack stack, @NotNull Player player, InteractionHand hand) {
        if (!player.getCommandSenderWorld().isClientSide) {
            player.openMenu((MenuProvider)new ContainerProvider(stack));
        }
    }

    @Override
    public void chargeKeyPressed(@NotNull ItemStack stack, @NotNull Player player, InteractionHand hand, boolean shiftKeyDown) {
        if (!shiftKeyDown) {
            if (this.getCharge(stack) < this.maxCharge(stack)) {
                this.setCharge(stack, this.getCharge(stack) + 1);
            }
        } else if (this.getCharge(stack) > 0) {
            this.setCharge(stack, this.getCharge(stack) - 1);
        }
    }

    @Override
    public int getCharge(@NotNull ItemStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        if (!tag.contains("charge")) {
            tag.putInt("charge", 0);
        }
        return tag.getInt("charge");
    }

    @Override
    public void setCharge(@NotNull ItemStack stack, int value) {
        CompoundTag tag = stack.getOrCreateTag();
        tag.putInt("charge", value);
    }

    @Override
    public int maxCharge(@NotNull ItemStack stack) {
        return 5;
    }

    public boolean isBarVisible(@NotNull ItemStack itemStack) {
        return true;
    }

    public int getBarWidth(@NotNull ItemStack itemStack) {
        return Math.round((float)this.getCharge(itemStack) * 13.0f / (float)this.maxCharge(itemStack));
    }

    @Override
    public int getRange(ItemStack stack) {
        return this.getCharge(stack);
    }

    @Override
    public Color getColour(ItemStack stack) {
        return Color.WHITE;
    }

    private static /* synthetic */ void lambda$getChanges$1(Level level, Block targetBlock, Map conversions, boolean isSneaking, Map changes, BlockPos currentPos) {
        BlockState state = level.getBlockState(currentPos);
        if (state.is(targetBlock)) {
            BlockState actualResult;
            if (conversions.containsKey(state)) {
                actualResult = (BlockState)conversions.get(state);
            } else {
                actualResult = ItemPhilosophersStone.getTransmutation(state, isSneaking);
                conversions.put(state, actualResult);
            }
            if (actualResult != null) {
                changes.put(currentPos.immutable(), actualResult);
            }
        }
    }

    private record ContainerProvider(ItemStack stack) implements MenuProvider
    {
        @NotNull
        public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player player) {
            return new PhilosophersStoneContainer(windowId, playerInventory, ContainerLevelAccess.create((Level)player.getCommandSenderWorld(), (BlockPos)player.blockPosition()));
        }

        @NotNull
        public Component getDisplayName() {
            return this.stack.getHoverName();
        }
    }
}

