/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.items.prefab;

import java.util.List;
import net.creeperhost.equivalentexchange.api.EmcFormatter;
import net.creeperhost.equivalentexchange.api.emcstorage.IEmcItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemWithEmc
extends Item
implements IEmcItem {
    double capacity;
    double maxReceive;
    double maxExtract;

    public ItemWithEmc(Item.Properties properties, double capacity, double maxReceive, double maxExtract) {
        super(properties);
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public boolean isBarVisible(@NotNull ItemStack itemStack) {
        return true;
    }

    public int getBarWidth(@NotNull ItemStack itemStack) {
        return Math.round((float)this.getStoredEmc(itemStack) * 13.0f / (float)this.getMaxStored(itemStack));
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, level, list, tooltipFlag);
        if (this.capacity > 0.0) {
            list.add((Component)Component.literal((String)(ChatFormatting.GOLD + "Stored EMC" + ChatFormatting.WHITE + ": " + EmcFormatter.formatEmcValue(this.getStoredEmc(itemStack)) + " / " + EmcFormatter.formatEmcValue(this.getMaxStored(itemStack)))));
        }
    }

    @Override
    public double receiveEmc(ItemStack stack, double maxReceive, boolean simulate) {
        if (!this.canReceive(stack)) {
            return 0.0;
        }
        double emcReceived = Math.min(this.capacity - this.getStoredEmc(stack), Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            double value = this.getStoredEmc(stack) + emcReceived;
            this.setStoredEmc(stack, value);
        }
        return emcReceived;
    }

    @Override
    public double extractEmc(ItemStack stack, double maxExtract, boolean simulate) {
        if (!this.canExtract(stack)) {
            return 0.0;
        }
        double emcExtracted = Math.min(this.getStoredEmc(stack), Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            double value = this.getStoredEmc(stack) - emcExtracted;
            this.setStoredEmc(stack, value);
        }
        return emcExtracted;
    }

    @Override
    public void setStoredEmc(ItemStack stack, double value) {
        stack.getOrCreateTag().putDouble("emc", value);
    }

    @Override
    public double getStoredEmc(ItemStack stack) {
        return stack.getOrCreateTag().getDouble("emc");
    }

    @Override
    public double getMaxStored(ItemStack stack) {
        return this.capacity;
    }

    @Override
    public boolean canExtract(ItemStack stack) {
        return this.maxExtract > 0.0;
    }

    @Override
    public boolean canReceive(ItemStack stack) {
        return this.maxReceive > 0.0;
    }
}

