/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.items.tools;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.creeperhost.equivalentexchange.EquivalentExchange;
import net.creeperhost.equivalentexchange.items.interfaces.IChargeableItem;
import net.creeperhost.equivalentexchange.items.interfaces.IOverlayItem;
import net.creeperhost.equivalentexchange.items.prefab.FuelUsingItem;
import net.creeperhost.polylib.helpers.LevelHelper;
import net.creeperhost.polylib.helpers.VectorHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDestructionCatalyst
extends FuelUsingItem
implements IOverlayItem,
IChargeableItem {
    public ItemDestructionCatalyst() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    public boolean blockIgnored(BlockState blockState) {
        return ItemDestructionCatalyst.blockIgnoredStatic(blockState);
    }

    public static boolean blockIgnoredStatic(BlockState blockState) {
        return blockState.is(BlockTags.FEATURES_CANNOT_REPLACE) || blockState.is(Blocks.AIR) || blockState.is(Blocks.WATER) || blockState.is(Blocks.LAVA);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!this.hasEnoughFuel(player, EquivalentExchange.CONFIG_DATA.DestructionCatalystUseCost)) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)itemStack);
        }
        int hitRange = 5;
        BlockHitResult hitResult = VectorHelper.getLookingAt((Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY, (int)hitRange);
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            BlockPos targetPos = hitResult.getBlockPos();
            Direction targetFace = hitResult.getDirection();
            int range = this.getRange(itemStack);
            ArrayList drops = new ArrayList();
            Iterable positions = LevelHelper.getPositionsFromBox((AABB)LevelHelper.getAABBbox((BlockPos)targetPos, (Direction)targetFace, (int)range--));
            for (BlockPos pos : positions) {
                BlockState blockState = level.getBlockState(pos);
                if (this.blockIgnored(blockState)) continue;
                drops.addAll(Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null, (Entity)player, (ItemStack)itemStack));
                level.removeBlock(pos, false);
            }
            for (ItemStack drop : drops) {
                ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), drop);
                level.addFreshEntity((Entity)item);
            }
            this.useFuel(player, EquivalentExchange.CONFIG_DATA.DestructionCatalystUseCost);
            return InteractionResultHolder.success((Object)itemStack);
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }

    public static Map<BlockPos, BlockState> getChanges(Level level, BlockPos pos, Player player, Direction sideHit, int charge) {
        Stream stream = null;
        if (sideHit == Direction.SOUTH) {
            stream = BlockPos.betweenClosedStream((BlockPos)pos.offset(-1, -1, -charge), (BlockPos)pos.offset(1, 1, 0));
        }
        if (sideHit == Direction.NORTH) {
            stream = BlockPos.betweenClosedStream((BlockPos)pos.offset(-1, -1, charge), (BlockPos)pos.offset(1, 1, 0));
        }
        if (sideHit == Direction.EAST) {
            stream = BlockPos.betweenClosedStream((BlockPos)pos.offset(0, -1, -1), (BlockPos)pos.offset(-charge, 1, 1));
        }
        if (sideHit == Direction.WEST) {
            stream = BlockPos.betweenClosedStream((BlockPos)pos.offset(charge, -1, -1), (BlockPos)pos.offset(0, 1, 1));
        }
        if (sideHit == Direction.DOWN) {
            stream = BlockPos.betweenClosedStream((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, charge, 1));
        }
        if (sideHit == Direction.UP) {
            stream = BlockPos.betweenClosedStream((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, -charge, 1));
        }
        if (stream == null) {
            return Collections.emptyMap();
        }
        HashMap<BlockPos, BlockState> changes = new HashMap<BlockPos, BlockState>();
        stream.forEach(currentPos -> {
            if (!ItemDestructionCatalyst.blockIgnoredStatic(level.getBlockState(currentPos))) {
                changes.put(currentPos.immutable(), level.getBlockState(currentPos));
            }
        });
        return changes;
    }

    @Override
    public int getRange(ItemStack stack) {
        return this.getCharge(stack);
    }

    @Override
    public Color getColour(ItemStack stack) {
        return Color.RED;
    }

    @Override
    public int getCharge(@NotNull ItemStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        if (!tag.contains("charge")) {
            tag.putInt("charge", 0);
        }
        return tag.getInt("charge");
    }

    @Override
    public void setCharge(@NotNull ItemStack stack, int value) {
        CompoundTag tag = stack.getOrCreateTag();
        tag.putInt("charge", value);
    }

    @Override
    public int maxCharge(@NotNull ItemStack stack) {
        return 5;
    }

    public boolean isBarVisible(@NotNull ItemStack itemStack) {
        return true;
    }

    public int getBarWidth(@NotNull ItemStack itemStack) {
        return Math.round((float)this.getCharge(itemStack) * 13.0f / (float)this.maxCharge(itemStack));
    }

    public void appendHoverText(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, level, list, tooltipFlag);
        list.add((Component)Component.literal((String)("Range: " + this.getRange(itemStack))));
    }

    @Override
    public void chargeKeyPressed(@NotNull ItemStack stack, @NotNull Player player, InteractionHand hand, boolean shiftKeyDown) {
        if (!shiftKeyDown) {
            if (this.getCharge(stack) < this.maxCharge(stack)) {
                this.setCharge(stack, this.getCharge(stack) + 1);
            }
        } else if (this.getCharge(stack) > 0) {
            this.setCharge(stack, this.getCharge(stack) - 1);
        }
    }
}

