/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.items.tools;

import net.creeperhost.equivalentexchange.items.interfaces.IChargeableItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import org.jetbrains.annotations.NotNull;

public class ItemDmPickaxe
extends PickaxeItem
implements IChargeableItem {
    public ItemDmPickaxe(Tier tier, int i, float f, Item.Properties properties) {
        super(tier, i, f, properties);
    }

    public boolean isBarVisible(ItemStack itemStack) {
        return true;
    }

    public int getBarWidth(@NotNull ItemStack itemStack) {
        return Math.round((float)this.getCharge(itemStack) * 13.0f / (float)this.maxCharge(itemStack));
    }

    @Override
    public int getCharge(@NotNull ItemStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        if (!tag.contains("charge")) {
            tag.putInt("charge", 0);
        }
        return tag.getInt("charge");
    }

    @Override
    public void setCharge(@NotNull ItemStack stack, int value) {
        CompoundTag tag = stack.getOrCreateTag();
        tag.putInt("charge", value);
    }

    @Override
    public int maxCharge(@NotNull ItemStack stack) {
        return 5;
    }

    @Override
    public void chargeKeyPressed(@NotNull ItemStack stack, @NotNull Player player, InteractionHand hand, boolean shiftKeyDown) {
        if (!shiftKeyDown) {
            if (this.getCharge(stack) < this.maxCharge(stack)) {
                this.setCharge(stack, this.getCharge(stack) + 1);
            }
        } else if (this.getCharge(stack) > 0) {
            this.setCharge(stack, this.getCharge(stack) - 1);
        }
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }
}

