/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.items.toys;

import java.util.List;
import net.creeperhost.equivalentexchange.api.EmcFormatter;
import net.creeperhost.equivalentexchange.api.emcstorage.IEmcItem;
import net.creeperhost.equivalentexchange.api.item.IKleinStarItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBootsOfDirewolf
extends ArmorItem
implements IEmcItem {
    private double capacity = 1000.0;
    private double cost = 20.0;

    public ItemBootsOfDirewolf() {
        super((ArmorMaterial)ArmorMaterials.LEATHER, ArmorItem.Type.BOOTS, new Item.Properties().stacksTo(1));
    }

    public void inventoryTick(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Entity entity, int i, boolean bl) {
        super.inventoryTick(itemStack, level, entity, i, bl);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.consumeEmc(itemStack, player);
            if (player.getInventory().getArmor(0).getItem() == this) {
                player.resetFallDistance();
                if (player.getAbilities().flying) {
                    if (this.getStoredEmc(itemStack) > this.cost) {
                        this.extractEmc(itemStack, this.cost, false);
                    } else {
                        player.getAbilities().mayfly = false;
                        player.getAbilities().flying = false;
                    }
                } else if (!player.getAbilities().mayfly && this.getStoredEmc(itemStack) > this.cost) {
                    player.getAbilities().mayfly = true;
                }
            }
        }
    }

    public void consumeEmc(ItemStack itemStack, Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            Item item;
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof IKleinStarItem)) continue;
            IKleinStarItem itemKleinStar = (IKleinStarItem)item;
            double removed = this.receiveEmc(itemStack, Math.min(itemKleinStar.getKleinStarStored(stack), 1000.0), false);
            itemKleinStar.extractKleinStarEmc(stack, removed, false);
            break;
        }
    }

    public void onEquip(Player player) {
        player.getAbilities().mayfly = true;
    }

    public void onUnEquip(Player player) {
        if (!player.isCreative()) {
            player.getAbilities().mayfly = false;
            player.getAbilities().flying = false;
        }
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, level, list, tooltipFlag);
        list.add((Component)Component.literal((String)(ChatFormatting.DARK_PURPLE + "Stored EMC" + ChatFormatting.WHITE + ": " + EmcFormatter.formatEmcValue(this.getStoredEmc(itemStack)) + " / " + EmcFormatter.formatEmcValue(this.getMaxStored(itemStack)))));
    }

    @Override
    public double receiveEmc(ItemStack stack, double maxReceive, boolean simulate) {
        if (!this.canReceive(stack)) {
            return 0.0;
        }
        double emcReceived = Math.min(this.capacity - this.getStoredEmc(stack), Math.min(this.capacity, maxReceive));
        if (!simulate) {
            double value = this.getStoredEmc(stack) + emcReceived;
            this.setStoredEmc(stack, value);
        }
        return emcReceived;
    }

    @Override
    public double extractEmc(ItemStack stack, double maxExtract, boolean simulate) {
        double emcExtracted = Math.min(this.getStoredEmc(stack), Math.min(this.capacity, maxExtract));
        if (!simulate) {
            double value = this.getStoredEmc(stack) - emcExtracted;
            this.setStoredEmc(stack, value);
        }
        return emcExtracted;
    }

    @Override
    public void setStoredEmc(ItemStack stack, double value) {
        stack.getOrCreateTag().putDouble("emc", value);
    }

    @Override
    public double getStoredEmc(ItemStack stack) {
        return stack.getOrCreateTag().getDouble("emc");
    }

    @Override
    public double getMaxStored(ItemStack stack) {
        return this.capacity;
    }

    @Override
    public boolean canExtract(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canReceive(ItemStack stack) {
        return true;
    }
}

