/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.items.toys;

import net.creeperhost.equivalentexchange.EquivalentExchange;
import net.creeperhost.equivalentexchange.items.prefab.FuelUsingItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemRepairTalisman
extends FuelUsingItem {
    double cost;
    int ticks;

    public ItemRepairTalisman() {
        super(new Item.Properties().stacksTo(1));
        this.cost = EquivalentExchange.CONFIG_DATA.RepairTalismanCost;
        this.ticks = 0;
    }

    public void inventoryTick(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Entity entity, int i, boolean bl) {
        if (level.isClientSide()) {
            return;
        }
        ++this.ticks;
        if (this.ticks == 200) {
            Player player;
            this.ticks = 0;
            if (entity instanceof Player && this.hasEnoughFuel(player = (Player)entity, this.cost)) {
                this.repairAllItems(player.getInventory());
            }
        }
    }

    public boolean canRepair(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (!stack.isDamageableItem()) {
            return false;
        }
        return stack.getDamageValue() > 0;
    }

    private void repairAllItems(Inventory inv) {
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack invStack = inv.getItem(i);
            if (!this.canRepair(invStack)) continue;
            this.useFuel(inv.player, this.cost);
            invStack.setDamageValue(invStack.getDamageValue() - 1);
        }
    }
}

