/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.items.toys.amulets;

import net.creeperhost.equivalentexchange.EquivalentExchange;
import net.creeperhost.equivalentexchange.api.item.IKleinStarItem;
import net.creeperhost.equivalentexchange.api.item.IPedestalItem;
import net.creeperhost.equivalentexchange.entities.EntityVolcaniteProjectile;
import net.creeperhost.equivalentexchange.init.ModSounds;
import net.creeperhost.equivalentexchange.items.interfaces.IActionItem;
import net.creeperhost.equivalentexchange.items.prefab.FuelUsingItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import org.jetbrains.annotations.NotNull;

public class ItemVolcanite
extends FuelUsingItem
implements IPedestalItem,
IActionItem {
    public ItemVolcanite() {
        super(new Item.Properties().stacksTo(1));
    }

    public boolean hasCraftingRemainingItem() {
        return true;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext useOnContext) {
        Player player = useOnContext.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = useOnContext.getLevel();
        BlockPos clickedPos = useOnContext.getClickedPos();
        Direction sideHit = useOnContext.getClickedFace();
        if (this.hasEnoughFuel(player, EquivalentExchange.CONFIG_DATA.VolcaniteLavaCost)) {
            BlockPos placePos = clickedPos.relative(sideHit, 1);
            level.setBlock(placePos, Blocks.LAVA.defaultBlockState(), 3);
            this.useFuel(player, EquivalentExchange.CONFIG_DATA.VolcaniteLavaCost);
            if (level.isClientSide()) {
                level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.TRANSMUTE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(useOnContext);
    }

    @Override
    public void pedestalTick(Level level, BlockPos blockPos, ItemStack stack, ItemStack starStack) {
        ServerLevelData serverLevelData;
        LevelData levelData;
        IKleinStarItem iKleinStarItem;
        double stored;
        Item item;
        if (!level.isClientSide() && (item = starStack.getItem()) instanceof IKleinStarItem && (stored = (iKleinStarItem = (IKleinStarItem)item).getKleinStarStored(starStack)) >= EquivalentExchange.CONFIG_DATA.VolcanitePedestalCost && (levelData = level.getLevelData()) instanceof ServerLevelData && ((serverLevelData = (ServerLevelData)levelData).isRaining() || serverLevelData.isThundering())) {
            serverLevelData.setRainTime(0);
            serverLevelData.setThunderTime(0);
            serverLevelData.setRaining(false);
            serverLevelData.setThundering(false);
            iKleinStarItem.extractKleinStarEmc(starStack, EquivalentExchange.CONFIG_DATA.VolcanitePedestalCost, false);
        }
    }

    @Override
    public void onActionKeyPressed(@NotNull ItemStack stack, @NotNull Player player, InteractionHand hand) {
        Level level = player.level();
        EntityVolcaniteProjectile ent = new EntityVolcaniteProjectile(player, level);
        ent.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
        level.addFreshEntity((Entity)ent);
        player.swing(hand);
    }
}

