/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.items.toys.stones;

import java.util.List;
import net.creeperhost.equivalentexchange.items.interfaces.IActiveItem;
import net.creeperhost.equivalentexchange.items.prefab.FuelUsingItem;
import net.creeperhost.polylib.helpers.RegistryNameHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStone
extends FuelUsingItem
implements IActiveItem {
    public ItemStone() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack stack = player.getItemInHand(interactionHand);
        if (player.isCrouching()) {
            this.toggleActive(stack);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, interactionHand);
    }

    public void toggleActive(ItemStack stack) {
        this.setActive(stack, !this.isActive(stack));
    }

    @Override
    public boolean isActive(ItemStack stack) {
        return stack.getOrCreateTag().getBoolean("active");
    }

    public void setActive(ItemStack stack, boolean value) {
        stack.getOrCreateTag().putBoolean("active", value);
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            String name = ((ResourceLocation)RegistryNameHelper.getRegistryName((Item)itemStack.getItem()).get()).toString();
            list.add((Component)Component.translatable((String)("tooltip.equivalentexchange." + name)));
        } else {
            super.appendHoverText(itemStack, level, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"tooltip.equivalentexchange.hold_shift"));
        }
    }
}

