/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.network.packets;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import net.creeperhost.equivalentexchange.impl.AlchemicalBagHandler;
import net.creeperhost.equivalentexchange.inventory.AlchemicalBagInventory;
import net.creeperhost.equivalentexchange.network.PacketHandler;
import net.creeperhost.equivalentexchange.types.BagTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class AlchemicalBagPacket
extends BaseS2CMessage {
    CompoundTag compoundTag;
    BagTypes bagTypes;

    public AlchemicalBagPacket(CompoundTag compoundTag, BagTypes bagType) {
        this.compoundTag = compoundTag;
        this.bagTypes = bagType;
    }

    public AlchemicalBagPacket(FriendlyByteBuf friendlyByteBuf) {
        this.compoundTag = friendlyByteBuf.readNbt();
        this.bagTypes = BagTypes.valueOf(friendlyByteBuf.readUtf());
    }

    public MessageType getType() {
        return PacketHandler.ALCHEMICAL_BAG_PACKET;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.compoundTag);
        buf.writeUtf(this.bagTypes.name());
    }

    public void handle(NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (player != null) {
            AlchemicalBagInventory alchemicalBagInventory = new AlchemicalBagInventory(player);
            alchemicalBagInventory.deserializeNBT(this.compoundTag);
            AlchemicalBagHandler.updateInventory(player, alchemicalBagInventory, this.bagTypes);
        }
    }
}

