/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.network.packets;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import net.creeperhost.equivalentexchange.items.interfaces.IChargeableItem;
import net.creeperhost.equivalentexchange.network.PacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ChargeKeyPacket
extends BaseC2SMessage {
    boolean shiftDown;

    public ChargeKeyPacket(boolean shiftDown) {
        this.shiftDown = shiftDown;
    }

    public ChargeKeyPacket(FriendlyByteBuf friendlyByteBuf) {
        this.shiftDown = friendlyByteBuf.readBoolean();
    }

    public MessageType getType() {
        return PacketHandler.CHARGE_KEY;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.shiftDown);
    }

    public void handle(NetworkManager.PacketContext context) {
        Item item;
        if (context.getPlayer() == null) {
            return;
        }
        Player player = context.getPlayer();
        ItemStack stack = player.getMainHandItem();
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof IChargeableItem) {
            IChargeableItem item2 = (IChargeableItem)item;
            item2.chargeKeyPressed(stack, player, InteractionHand.MAIN_HAND, this.shiftDown);
        }
    }
}

