/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.network.packets;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.HashMap;
import net.creeperhost.equivalentexchange.EquivalentExchange;
import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.creeperhost.equivalentexchange.network.PacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class EmcValuesPacket
extends BaseS2CMessage {
    HashMap<ResourceLocation, Double> EMC_VALUES;

    public EmcValuesPacket(HashMap<ResourceLocation, Double> values) {
        this.EMC_VALUES = values;
    }

    public EmcValuesPacket(FriendlyByteBuf friendlyByteBuf) {
        this.EMC_VALUES = (HashMap)friendlyByteBuf.readMap(FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::readDouble);
    }

    public MessageType getType() {
        return PacketHandler.EMC_VALUE_SYNC;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeMap(this.EMC_VALUES, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::writeDouble);
    }

    public void handle(NetworkManager.PacketContext context) {
        if (context.getPlayer() == null) {
            return;
        }
        if (context.getPlayer().level().isClientSide) {
            EquivalentExchange.LOGGER.info("New emv values sent from server, Updating");
            EquivalentExchangeAPI.EMC_VALUES = this.EMC_VALUES;
        }
    }
}

