/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.network.packets;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import net.creeperhost.equivalentexchange.impl.TransmutationTableHandler;
import net.creeperhost.equivalentexchange.inventory.TransmutationInventory;
import net.creeperhost.equivalentexchange.network.PacketHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class TransmutationInventoryPacket
extends BaseS2CMessage {
    CompoundTag compoundTag;

    public TransmutationInventoryPacket(CompoundTag compoundTag) {
        this.compoundTag = compoundTag;
    }

    public TransmutationInventoryPacket(FriendlyByteBuf friendlyByteBuf) {
        this.compoundTag = friendlyByteBuf.readNbt();
    }

    public MessageType getType() {
        return PacketHandler.TRANSMUTATION_TABLE_PACKET;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.compoundTag);
    }

    public void handle(NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (player != null) {
            TransmutationInventory transmutationInventory = new TransmutationInventory(player);
            transmutationInventory.deserializeNBT(this.compoundTag);
            transmutationInventory.updateInventory();
            TransmutationTableHandler.updateInventory(player, transmutationInventory);
        }
    }
}

