/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.polylib;

import net.minecraft.world.entity.player.Player;

public class ExperienceHelper {
    public static int getPlayersXP(Player player) {
        return (int)((float)ExperienceHelper.getXPForLvl(player.experienceLevel) + player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static void removeXP(Player player, int amount) {
        int totalExperience = ExperienceHelper.getPlayersXP(player) - amount;
        if (totalExperience < 0) {
            player.totalExperience = 0;
            player.experienceLevel = 0;
            player.experienceProgress = 0.0f;
        } else {
            player.totalExperience = totalExperience;
            player.experienceLevel = ExperienceHelper.getLvlForXP(totalExperience);
            player.experienceProgress = (float)(totalExperience - ExperienceHelper.getXPForLvl(player.experienceLevel)) / (float)player.getXpNeededForNextLevel();
        }
    }

    public static void addXP(Player player, int amount) {
        int exp;
        player.totalExperience = exp = ExperienceHelper.getPlayersXP(player) + amount;
        player.experienceLevel = ExperienceHelper.getLvlForXP(exp);
        player.experienceProgress = (float)(exp - ExperienceHelper.getXPForLvl(player.experienceLevel)) / (float)player.getXpNeededForNextLevel();
    }

    public static int getXPForLvl(int level) {
        if (level < 0) {
            return Integer.MAX_VALUE;
        }
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)((double)(level * level) * 2.5 - 40.5 * (double)level + 360.0);
        }
        return (int)((double)(level * level) * 4.5 - 162.5 * (double)level + 2220.0);
    }

    public static int getLvlForXP(int totalXP) {
        int result = 0;
        while (ExperienceHelper.getXPForLvl(result) <= totalXP) {
            ++result;
        }
        return --result;
    }
}

