/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.recipes;

import java.util.ArrayList;
import net.creeperhost.equivalentexchange.Constants;
import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.creeperhost.equivalentexchange.api.EquivalentExchangeTags;
import net.creeperhost.equivalentexchange.init.ModRecipes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipesCovalenceRepair
extends CustomRecipe {
    public RecipesCovalenceRepair(CraftingBookCategory category) {
        super(category);
    }

    @Nullable
    private RepairTargetInfo findIngredients(CraftingContainer inv) {
        ArrayList<ItemStack> dust = new ArrayList<ItemStack>();
        ItemStack tool = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack input = inv.getItem(i);
            if (input.isEmpty()) continue;
            if (input.is(EquivalentExchangeTags.COVALENCE_DUST)) {
                dust.add(input);
                continue;
            }
            if (tool.isEmpty() && input.isDamageableItem() && input.isDamageableItem() && input.getDamageValue() > 0) {
                tool = input;
                continue;
            }
            return null;
        }
        if (tool.isEmpty() || dust.isEmpty()) {
            return null;
        }
        return new RepairTargetInfo(tool, dust.stream().mapToDouble(EquivalentExchangeAPI::getEmcValue).sum());
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level level) {
        RepairTargetInfo targetInfo = this.findIngredients(inv);
        return targetInfo != null && (double)targetInfo.emcPerDurability <= targetInfo.dustEmc;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registryAccess) {
        RepairTargetInfo targetInfo = this.findIngredients(inv);
        if (targetInfo == null) {
            return ItemStack.EMPTY;
        }
        ItemStack output = targetInfo.tool.copy();
        output.setDamageValue((int)Math.max((double)output.getDamageValue() - targetInfo.dustEmc / (double)targetInfo.emcPerDurability, 0.0));
        return output;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width > 1 || height > 1;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.COVALENCE_REPAIR.get();
    }

    private static class RepairTargetInfo {
        private final ItemStack tool;
        private final long emcPerDurability;
        private final double dustEmc;

        public RepairTargetInfo(ItemStack tool, double emc) {
            this.tool = tool;
            this.dustEmc = emc;
            this.emcPerDurability = Constants.getEMCPerDurability(tool);
        }
    }
}

