/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.server;

import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.creeperhost.equivalentexchange.impl.AlchemicalBagHandler;
import net.creeperhost.equivalentexchange.impl.TransmutationTableHandler;
import net.creeperhost.equivalentexchange.network.packets.EmcValuesPacket;
import net.creeperhost.equivalentexchange.network.packets.PlayerEmcPacket;
import net.creeperhost.equivalentexchange.network.packets.knowledge.KnowledgePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ServerEvents {
    public static void onLevelSave(ServerLevel serverLevel) {
        AlchemicalBagHandler.onServerSaveEvent(serverLevel);
        ServerEvents.save(serverLevel);
    }

    private static void save(ServerLevel serverLevel) {
        if (serverLevel != null && serverLevel.players() != null && !serverLevel.players().isEmpty()) {
            try {
                serverLevel.players().forEach(serverPlayer -> {
                    EquivalentExchangeAPI.getStorageHandler().saveEmcToFile((Player)serverPlayer);
                    EquivalentExchangeAPI.getKnowledgeHandler().saveKnowledgeToFile((Player)serverPlayer);
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AlchemicalBagHandler.onServerSaveEvent(serverLevel);
    }

    public static void onPlayerJoin(ServerPlayer serverPlayer) {
        TransmutationTableHandler.getTransmutationInventory((Player)serverPlayer);
        AlchemicalBagHandler.onPlayerJoinEvent(serverPlayer);
        EquivalentExchangeAPI.getStorageHandler().loadPlayersEmcFromFile((Player)serverPlayer);
        new PlayerEmcPacket(EquivalentExchangeAPI.getStorageHandler().getEmcValueFor((Player)serverPlayer)).sendTo(serverPlayer);
        EquivalentExchangeAPI.getKnowledgeHandler().loadKnowledgeFromFile((Player)serverPlayer);
        new KnowledgePacket(EquivalentExchangeAPI.getKnowledgeHandler().getKnowledgeList((Player)serverPlayer));
        if (!EquivalentExchangeAPI.UpdatingValues) {
            new EmcValuesPacket(EquivalentExchangeAPI.EMC_VALUES).sendTo(serverPlayer);
        }
    }

    public static void onServerStop(MinecraftServer minecraftServer) {
        TransmutationTableHandler.clear();
        AlchemicalBagHandler.onServerStopEvent(minecraftServer);
        minecraftServer.getAllLevels().forEach(ServerEvents::save);
        EquivalentExchangeAPI.getStorageHandler().clear();
        EquivalentExchangeAPI.getKnowledgeHandler().clear();
    }

    public static void onServerLoad(ServerLevel serverLevel) {
    }
}

