/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CommandKnowledge {
    public static LiteralArgumentBuilder<CommandSourceStack> register(CommandBuildContext commandBuildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"knowledge").requires(cs -> cs.hasPermission(3))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(cs -> CommandKnowledge.execute((CommandContext<CommandSourceStack>)cs, EntityArgument.getPlayers((CommandContext)cs, (String)"targets"), "list", new ItemInput(ItemStack.EMPTY.getItem().arch$holder(), new CompoundTag())))).then(((RequiredArgumentBuilder)Commands.argument((String)"arg1", (ArgumentType)StringArgumentType.string()).executes(cs -> CommandKnowledge.execute((CommandContext<CommandSourceStack>)cs, EntityArgument.getPlayers((CommandContext)cs, (String)"targets"), StringArgumentType.getString((CommandContext)cs, (String)"arg1"), new ItemInput(ItemStack.EMPTY.getItem().arch$holder(), new CompoundTag())))).then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)commandBuildContext)).executes(cs -> CommandKnowledge.execute((CommandContext<CommandSourceStack>)cs, EntityArgument.getPlayers((CommandContext)cs, (String)"targets"), StringArgumentType.getString((CommandContext)cs, (String)"arg1"), ItemArgument.getItem((CommandContext)cs, (String)"item"))))));
    }

    private static int execute(CommandContext<CommandSourceStack> cs, Collection<ServerPlayer> targets, String arg1, ItemInput item) {
        switch (arg1) {
            case "list": {
                for (ServerPlayer target : targets) {
                    List<ItemStack> list = EquivalentExchangeAPI.iKnowledgeHandler.getKnowledgeList((Player)target);
                    if (list.isEmpty()) {
                        ((CommandSourceStack)cs.getSource()).sendFailure((Component)Component.literal((String)"Knowledge list is empty"));
                    }
                    for (ItemStack stack : list) {
                        if (stack.isEmpty()) continue;
                        ((CommandSourceStack)cs.getSource()).sendSuccess(() -> Component.literal((String)stack.getItem().getName(stack).getString()), false);
                    }
                }
                break;
            }
            case "add": {
                for (ServerPlayer target : targets) {
                    ItemStack stack = ItemStack.EMPTY;
                    try {
                        stack = item.createItemStack(1, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!stack.isEmpty()) {
                        EquivalentExchangeAPI.getKnowledgeHandler().addKnowledge((Player)target, stack);
                        ItemStack finalStack = stack;
                        ((CommandSourceStack)cs.getSource()).sendSuccess(() -> Component.literal((String)("Added knowledge for " + finalStack.getItem().getName(finalStack).getString() + " to " + target.getDisplayName().getString())), false);
                        continue;
                    }
                    ((CommandSourceStack)cs.getSource()).sendFailure((Component)Component.literal((String)"ItemStack.EMPTY is not a valid stack, Skipping"));
                }
                break;
            }
            default: {
                ((CommandSourceStack)cs.getSource()).sendFailure((Component)Component.literal((String)"Invalid argument"));
            }
        }
        return 0;
    }
}

