/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MIAdvancementTriggers;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MIVillager;
import aztech.modern_industrialization.api.datamaps.MIDataMaps;
import aztech.modern_industrialization.blocks.WrenchableBlockEntity;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlock;
import aztech.modern_industrialization.compat.ae2.MIAEAddon;
import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.datagen.MIDatagenServer;
import aztech.modern_industrialization.debug.DebugCommands;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.items.SteamDrillHooks;
import aztech.modern_industrialization.items.armor.MIArmorEffects;
import aztech.modern_industrialization.items.armor.MIKeyMap;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.init.MultiblockHatches;
import aztech.modern_industrialization.machines.init.MultiblockMachines;
import aztech.modern_industrialization.machines.init.SingleBlockCraftingMachines;
import aztech.modern_industrialization.machines.init.SingleBlockSpecialMachines;
import aztech.modern_industrialization.machines.multiblocks.world.ChunkEventListeners;
import aztech.modern_industrialization.materials.MIMaterials;
import aztech.modern_industrialization.misc.autotest.MIAutoTesting;
import aztech.modern_industrialization.misc.guidebook.GuidebookEvents;
import aztech.modern_industrialization.misc.runtime_datagen.RuntimeDataGen;
import aztech.modern_industrialization.network.MIPackets;
import aztech.modern_industrialization.nuclear.FluidNuclearComponent;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.resource.GeneratedPathPackResources;
import aztech.modern_industrialization.stats.PlayerStatisticsData;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="modern_industrialization")
public class MI {
    public static final String ID = "modern_industrialization";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Modern Industrialization");

    public static ResourceLocation id(String path) {
        return new ResourceLocation(ID, path);
    }

    public MI(IEventBus modBus, Dist dist) {
        KubeJSProxy.blockUntilKubeJSIsLoaded();
        MIAdvancementTriggers.init(modBus);
        MIFluids.init(modBus);
        MIBlock.init(modBus);
        MIItem.init(modBus);
        MIRegistries.init(modBus);
        MIMaterials.init();
        MIMachineRecipeTypes.init();
        SingleBlockCraftingMachines.init();
        SingleBlockSpecialMachines.init();
        MultiblockHatches.init();
        MultiblockMachines.init();
        KubeJSProxy.instance.fireRegisterMachinesEvent();
        MIPipes.INSTANCE.setup();
        CommonProxy.initEvents();
        ChunkEventListeners.init();
        DebugCommands.init();
        GuidebookEvents.init();
        MIArmorEffects.init();
        if (System.getProperty("modern_industrialization.autoTest") != null) {
            MIAutoTesting.init();
        }
        NeoForge.EVENT_BUS.addListener(PlayerEvent.PlayerChangedDimensionEvent.class, event -> MIKeyMap.clear(event.getEntity()));
        NeoForge.EVENT_BUS.addListener(PlayerEvent.PlayerLoggedOutEvent.class, event -> MIKeyMap.clear(event.getEntity()));
        NeoForge.EVENT_BUS.addListener(PlayerEvent.PlayerLoggedInEvent.class, event -> {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            MinecraftServer server = Objects.requireNonNull(player.getServer());
            PlayerStatisticsData.get(server).get((Player)player).onPlayerJoin(player);
        });
        NeoForge.EVENT_BUS.addListener(VillagerTradesEvent.class, MIVillager::init);
        NeoForge.EVENT_BUS.addListener(PlayerInteractEvent.RightClickBlock.class, event -> {
            WrenchableBlockEntity wrenchable;
            BlockEntity patt6970$temp;
            if (event.getUseBlock() == Event.Result.DENY) {
                return;
            }
            InteractionHand hand = event.getHand();
            BlockHitResult hitResult = event.getHitVec();
            Player player = event.getEntity();
            Level world = event.getLevel();
            if (player.isSpectator() || !event.getLevel().mayInteract(player, hitResult.getBlockPos())) {
                return;
            }
            if (player.getItemInHand(hand).is(MITags.WRENCHES) && (patt6970$temp = world.getBlockEntity(hitResult.getBlockPos())) instanceof WrenchableBlockEntity && (wrenchable = (WrenchableBlockEntity)patt6970$temp).useWrench(player, hand, hitResult)) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)world.isClientSide()));
            }
        });
        BarrelBlock.setupBarrelEvents();
        SteamDrillHooks.init();
        modBus.addListener(FMLCommonSetupEvent.class, event -> {
            MIBlock.BLOCK_DEFINITIONS.values().forEach(BlockDefinition::onRegister);
            MIItem.ITEM_DEFINITIONS.values().forEach(ItemDefinition::onRegister);
            FluidNuclearComponent.init();
        });
        modBus.addListener(GatherDataEvent.class, event -> MIDatagenServer.configure(event.getGenerator(), event.getExistingFileHelper(), event.getLookupProvider(), event.includeServer(), false));
        modBus.addListener(RegisterCapabilitiesEvent.class, MICapabilities::init);
        modBus.addListener(RegisterPayloadHandlerEvent.class, MIPackets::init);
        modBus.addListener(RegisterDataMapTypesEvent.class, event -> {
            event.register(MIDataMaps.FLUID_FUELS);
            event.register(MIDataMaps.ITEM_PIPE_UPGRADES);
        });
        if (MIConfig.loadAe2Compat()) {
            MIAEAddon.init(modBus);
        }
        modBus.addListener(AddPackFindersEvent.class, event -> {
            if (dist == Dist.DEDICATED_SERVER && event.getPackType() == PackType.SERVER_DATA && MIConfig.getConfig().datagenOnStartup) {
                RuntimeDataGen.run(MIDatagenServer::configure);
            }
            if (MIConfig.getConfig().loadRuntimeGeneratedResources) {
                event.addRepositorySource(consumer -> consumer.accept(Pack.create((String)"modern_industrialization/generated", (Component)MIText.GeneratedResources.text(), (boolean)true, (Pack.ResourcesSupplier)BuiltInPackSource.fixedResources((PackResources)new GeneratedPathPackResources(FMLPaths.GAMEDIR.get().resolve("modern_industrialization/generated_resources"), event.getPackType())), (Pack.Info)new Pack.Info((Component)MIText.GeneratedResourcesDescription.text(), PackCompatibility.COMPATIBLE, FeatureFlagSet.of(), List.of(), false), (Pack.Position)Pack.Position.TOP, (boolean)true, (PackSource)PackSource.BUILT_IN)));
            }
        });
        LOGGER.info("Modern Industrialization setup done!");
    }
}

