/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.datagen.translation.EnglishTranslation;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;

@Config(name="modern_industrialization")
public class MIConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public static final transient String NAME = "modern_industrialization";
    @EnglishTranslation(value="Enable login message when EMI, JEI and REI are missing")
    public boolean enableNoEmiMessage = true;
    @EnglishTranslation(value="Grant Guidebook at Spawn")
    public boolean spawnWithGuideBook = true;
    @EnglishTranslation(value="Grant Guidebook at Respawn")
    public boolean respawnWithGuideBook = true;
    @EnglishTranslation(value="Disable display of Fuel EU in tooltips")
    public boolean disableFuelTooltips = false;
    @EnglishTranslation(value="Disable display of Item Tag in tooltips")
    public boolean disableItemTagTooltips = FMLEnvironment.production;
    @EnglishTranslation(value="Display when a new version is available")
    public boolean newVersionMessage = true;
    @EnglishTranslation(value="Show valid positions in multiblocks when holding a hatch")
    public boolean enableHatchPlacementOverlay = true;
    @EnglishTranslation(value="Enable rendering of barrel content (item icon, item amount, and item name)")
    public boolean enableBarrelContentRendering = true;
    @ConfigEntry.Gui.RequiresRestart
    @EnglishTranslation(value="Color Water and Lava (Restart needed)")
    public boolean colorWaterLava = true;
    @EnglishTranslation(value="Enable UNSUPPORTED and DANGEROUS debug commands")
    public boolean enableDebugCommands = !FMLEnvironment.production;
    @ConfigEntry.Gui.RequiresRestart
    @EnglishTranslation(value="Enable bi-directional energy compatibility with Tech Reborn Energy. We recommend leaving this to false unless the other mods have been balanced accordingly. (Restart needed)")
    public boolean enableBidirectionalEnergyCompat = false;
    @ConfigEntry.Gui.RequiresRestart
    @EnglishTranslation(value="Enable the AE2 integration, if present (Restart needed)")
    public boolean enableAe2Integration = true;
    @ConfigEntry.Gui.RequiresRestart
    @EnglishTranslation(value="Enable the FTB Quests integration, if present (Restart needed)")
    public boolean enableFtbQuestsIntegration = true;
    @EnglishTranslation(value="Enable the default ore generation tooltips. Set this to false if you change the ore features in a datapack.")
    public boolean enableDefaultOreGenTooltips = true;
    @ConfigEntry.Gui.RequiresRestart
    @EnglishTranslation(value="Run MI runtime datagen on startup (Restart needed)")
    public boolean datagenOnStartup = false;
    @ConfigEntry.Gui.RequiresRestart
    @EnglishTranslation(value="Additionally load resources in modern_industrialization/generated_resources")
    public boolean loadRuntimeGeneratedResources = false;
    @ConfigEntry.Gui.RequiresRestart
    @EnglishTranslation(value="Removes trades from the Industrialist villager (Restart needed)")
    public boolean removeIndustrialistTrades = false;
    @ConfigEntry.Gui.RequiresRestart
    @EnglishTranslation(value="Maximum height of the Distillation Tower multiblock (Restart needed)")
    public int maxDistillationTowerHeight = 9;
    @EnglishTranslation(value="Enable inter-machine connected textures. (Requires a suitable resource pack)")
    public boolean enableInterMachineConnectedTextures = false;
    @ConfigEntry.Gui.Excluded
    private static volatile transient MIConfig instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized MIConfig getConfig() {
        MIConfig config = instance;
        if (config != null) return config;
        Class<MIConfig> clazz = MIConfig.class;
        synchronized (MIConfig.class) {
            config = instance;
            if (config != null) return config;
            instance = config = (MIConfig)AutoConfig.register(MIConfig.class, Toml4jConfigSerializer::new).getConfig();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return config;
        }
    }

    public static boolean loadAe2Compat() {
        return MIConfig.getConfig().enableAe2Integration && ModList.get().isLoaded("ae2");
    }
}

