/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.materials.part.OrePart;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class OreBlock
extends Block {
    public final OrePart.OrePartParams params;
    public final String materialName;

    public OreBlock(BlockBehaviour.Properties settings, OrePart.OrePartParams params, String materialName) {
        super(settings);
        this.params = params;
        this.materialName = materialName;
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack handStack = player.getMainHandItem();
        if (handStack.getItem() == Items.BOOK) {
            handStack.shrink(1);
            player.getInventory().placeItemBackInInventory(new ItemStack(MIItem.GUIDE_BOOK));
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.use(state, world, pos, player, hand, hit);
    }

    public void spawnAfterBreak(BlockState state, ServerLevel world, BlockPos pos, ItemStack stack, boolean bl) {
        int i;
        super.spawnAfterBreak(state, world, pos, stack, bl);
        if (bl && EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.SILK_TOUCH, (ItemStack)stack) == 0 && (i = this.params.xpDropped.sample(world.random)) > 0) {
            this.popExperience(world, pos, i);
        }
    }
}

