/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.forgehammer;

import aztech.modern_industrialization.MIRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record ForgeHammerRecipe(Ingredient ingredient, int count, ItemStack result, int hammerDamage) implements Recipe<Container>
{
    private static final Codec<ForgeHammerRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(ForgeHammerRecipe::ingredient), (App)ExtraCodecs.strictOptionalField((Codec)ExtraCodecs.POSITIVE_INT, (String)"count", (Object)1).forGetter(ForgeHammerRecipe::count), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter(ForgeHammerRecipe::result), (App)ExtraCodecs.strictOptionalField((Codec)ExtraCodecs.NON_NEGATIVE_INT, (String)"damage", (Object)0).forGetter(ForgeHammerRecipe::hammerDamage)).apply((Applicative)instance, ForgeHammerRecipe::new));

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(Container inv, Level world) {
        throw new UnsupportedOperationException();
    }

    public ItemStack assemble(Container inv, RegistryAccess registryAccess) {
        throw new UnsupportedOperationException();
    }

    public boolean canCraftInDimensions(int width, int height) {
        throw new UnsupportedOperationException();
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.copyOf(List.of(this.ingredient));
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return MIRegistries.FORGE_HAMMER_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)MIRegistries.FORGE_HAMMER_RECIPE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ForgeHammerRecipe> {
        public Codec<ForgeHammerRecipe> codec() {
            return CODEC;
        }

        public ForgeHammerRecipe fromNetwork(FriendlyByteBuf buf) {
            return new ForgeHammerRecipe(Ingredient.fromNetwork((FriendlyByteBuf)buf), buf.readVarInt(), buf.readItem(), buf.readVarInt());
        }

        public void toNetwork(FriendlyByteBuf buf, ForgeHammerRecipe recipe) {
            recipe.ingredient.toNetwork(buf);
            buf.writeVarInt(recipe.count);
            buf.writeItem(recipe.result);
            buf.writeVarInt(recipe.hammerDamage);
        }
    }
}

