/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.barrel;

import aztech.modern_industrialization.blocks.storage.AbstractStorageBlock;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlockEntity;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import aztech.modern_industrialization.util.MobSpawning;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class BarrelBlock
extends AbstractStorageBlock<ItemVariant>
implements EntityBlock {
    public BarrelBlock(EntityBlock factory, StorageBehaviour<ItemVariant> behaviour) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).destroyTime(4.0f).isValidSpawn(MobSpawning.NO_SPAWN), factory, behaviour);
    }

    private static boolean useBlock(BlockHitResult hitResult, InteractionHand hand, Player player, Level world) {
        BlockEntity blockEntity = world.getBlockEntity(hitResult.getBlockPos());
        if (blockEntity instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity;
            if (hitResult.getDirection().getAxis().isHorizontal()) {
                ItemVariant currentInHand;
                if (barrel.behaviour.isCreative() && !(currentInHand = ItemVariant.of(player.getMainHandItem())).isBlank() && barrel.isResourceBlank()) {
                    barrel.setResource(currentInHand);
                    return true;
                }
                if (!player.isShiftKeyDown()) {
                    ItemStack handItem = player.getItemInHand(hand);
                    if (!handItem.isEmpty()) {
                        try (Transaction tx = Transaction.openOuter();){
                            long inserted = barrel.insert(ItemVariant.of(handItem), handItem.getCount(), tx, true);
                            if (inserted > 0L) {
                                tx.commit();
                                handItem.shrink((int)inserted);
                                boolean bl = true;
                                return bl;
                            }
                        }
                    }
                } else {
                    currentInHand = ItemVariant.of(player.getMainHandItem());
                    if (!currentInHand.isBlank()) {
                        try (Transaction tx = Transaction.openOuter();){
                            long inserted = 0L;
                            for (int i = 0; i < 36; ++i) {
                                ItemStack stack = player.getInventory().getItem(i);
                                if (!currentInHand.matches(stack)) continue;
                                long thisIter = barrel.insert(currentInHand, stack.getCount(), tx, true);
                                inserted += thisIter;
                                stack.shrink((int)thisIter);
                            }
                            if (inserted > 0L) {
                                tx.commit();
                                boolean bl = true;
                                return bl;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean attackBlock(BlockPos pos, Direction direction, InteractionHand hand, Player player, Level world) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity;
            if (direction.getAxis().isHorizontal() && !barrel.isEmpty()) {
                ItemStack stack = player.getItemInHand(hand);
                try (Transaction transaction = Transaction.openOuter();){
                    ItemVariant extractedResource = (ItemVariant)barrel.getResource();
                    long extracted = barrel.extract(extractedResource, player.isShiftKeyDown() ? 1L : (long)extractedResource.toStack().getMaxStackSize(), (TransactionContext)transaction);
                    transaction.commit();
                    player.getInventory().placeItemBackInInventory(extractedResource.toStack((int)extracted));
                }
                return true;
            }
        }
        return false;
    }

    public static void setupBarrelEvents() {
        NeoForge.EVENT_BUS.addListener(PlayerInteractEvent.RightClickBlock.class, event -> {
            if (event.getUseBlock() == Event.Result.DENY) {
                return;
            }
            if (BarrelBlock.useBlock(event.getHitVec(), event.getHand(), event.getEntity(), event.getLevel())) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getSide().isClient()));
            }
        });
        NeoForge.EVENT_BUS.addListener(PlayerInteractEvent.LeftClickBlock.class, event -> {
            if (event.getAction() != PlayerInteractEvent.LeftClickBlock.Action.START) {
                return;
            }
            if (BarrelBlock.attackBlock(event.getPos(), event.getFace(), event.getHand(), event.getEntity(), event.getLevel())) {
                event.setCanceled(true);
            }
        });
    }

    public static BarrelStorage withStackCapacity(long stackCapacity) {
        return new BarrelStorage(stackCapacity);
    }

    public static class BarrelStorage
    extends StorageBehaviour<ItemVariant> {
        public final long stackCapacity;

        public BarrelStorage(long stackCapacity) {
            this.stackCapacity = stackCapacity;
        }

        @Override
        public boolean isLockable() {
            return true;
        }

        @Override
        public long getCapacityForResource(ItemVariant resource) {
            if (resource.isBlank()) {
                return this.stackCapacity * 64L;
            }
            return this.stackCapacity * (long)resource.getItem().getMaxStackSize();
        }

        @Override
        public boolean canInsert(ItemVariant resource) {
            return resource.getItem().canFitInsideContainerItems();
        }
    }
}

