/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.tank;

import aztech.modern_industrialization.blocks.storage.AbstractStorageBlockItem;
import aztech.modern_industrialization.blocks.storage.tank.TankBlock;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.NbtHelper;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TankItem
extends AbstractStorageBlockItem<FluidVariant> {
    public TankItem(TankBlock block, Item.Properties settings) {
        super(block, settings);
    }

    @Override
    public FluidVariant getResource(ItemStack stack) {
        CompoundTag tag = stack.getTagElement("BlockEntityTag");
        if (tag != null) {
            return NbtHelper.getFluidCompatible(tag, "fluid");
        }
        return FluidVariant.blank();
    }

    @Override
    public void setResourceNoClean(ItemStack stack, FluidVariant resource) {
        CompoundTag tag = stack.getOrCreateTagElement("BlockEntityTag");
        NbtHelper.putFluid(tag, "fluid", resource);
        this.onChange(stack);
    }

    @Override
    public void appendHoverText(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag context) {
        if (this.behaviour.isCreative()) {
            tooltip.add(FluidHelper.getFluidName(this.getResource(stack), true));
        } else {
            long capacity = this.behaviour.getCapacityForResource(this.getResource(stack));
            if (this.isEmpty(stack)) {
                if (!this.isUnlocked(stack)) {
                    tooltip.addAll(FluidHelper.getTooltipForFluidStorage(this.getResource(stack), 0L, capacity));
                } else {
                    tooltip.addAll(FluidHelper.getTooltipForFluidStorage(FluidVariant.blank(), 0L, capacity));
                }
            } else {
                tooltip.addAll(FluidHelper.getTooltipForFluidStorage(this.getResource(stack), this.getAmount(stack), capacity));
            }
        }
        super.appendHoverText(stack, world, tooltip, context);
    }
}

