/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.jei;

import aztech.modern_industrialization.compat.viewer.impl.ViewerUtil;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.client.fluid.FluidVariantRendering;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.RenderHelper;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.fluids.FluidStack;

class JeiSlotUtil {
    private JeiSlotUtil() {
    }

    public static void customizeTooltip(IRecipeSlotBuilder slot, float probability) {
        slot.addTooltipCallback((recipeSlotView, tooltip) -> {
            recipeSlotView.getDisplayedIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK).ifPresent(fluidIngredient -> tooltip.add(1, FluidHelper.getFluidAmount(fluidIngredient.getAmount())));
            boolean input = recipeSlotView.getRole() == RecipeIngredientRole.INPUT;
            Component probabilityLine = ViewerUtil.getProbabilityTooltip(probability, input);
            if (probabilityLine != null) {
                tooltip.add(probabilityLine);
            }
        });
    }

    public static void overrideFluidRenderer(IRecipeSlotBuilder slot) {
        slot.setCustomRenderer((IIngredientType)NeoForgeTypes.FLUID_STACK, (IIngredientRenderer)new IIngredientRenderer<FluidStack>(){

            public void render(GuiGraphics guiGraphics, FluidStack ingredient) {
                RenderHelper.drawFluidInGui(guiGraphics, FluidVariant.of(ingredient), 0, 0);
            }

            public List<Component> getTooltip(FluidStack ingredient, TooltipFlag tooltipFlag) {
                return FluidVariantRendering.getTooltip(FluidVariant.of(ingredient), tooltipFlag);
            }
        });
    }
}

