/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.jei;

import aztech.modern_industrialization.client.screen.MIHandledScreen;
import aztech.modern_industrialization.compat.viewer.ReiDraggable;
import aztech.modern_industrialization.network.machines.DoSlotDraggingPacket;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.Simulation;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

class MIGhostIngredientHandler
implements IGhostIngredientHandler<MIHandledScreen<?>> {
    MIGhostIngredientHandler() {
    }

    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(final MIHandledScreen<?> gui, ITypedIngredient<I> typedIngredient, boolean doStart) {
        ReiDraggable dw;
        ItemVariant itemVariant;
        FluidVariant fk;
        Object ingredient = typedIngredient.getIngredient();
        ArrayList<IGhostIngredientHandler.Target<I>> bounds = new ArrayList<IGhostIngredientHandler.Target<I>>();
        if (ingredient instanceof FluidStack) {
            FluidStack fs = (FluidStack)ingredient;
            v0 = FluidVariant.of(fs);
        } else {
            v0 = fk = null;
        }
        if (ingredient instanceof ItemStack) {
            ItemStack is = (ItemStack)ingredient;
            itemVariant = ItemVariant.of(is);
        } else {
            itemVariant = null;
        }
        final ItemVariant ik = itemVariant;
        for (GuiEventListener element : gui.children()) {
            if (!(element instanceof AbstractWidget)) continue;
            final AbstractWidget cw = (AbstractWidget)element;
            if (!(element instanceof ReiDraggable)) continue;
            dw = (ReiDraggable)element;
            if (ik != null && dw.dragItem(ik, Simulation.SIMULATE)) {
                bounds.add(new IGhostIngredientHandler.Target<I>(){

                    public Rect2i getArea() {
                        return MIGhostIngredientHandler.getWidgetBounds(cw);
                    }

                    public void accept(I ingredient) {
                        dw.dragItem(ik, Simulation.ACT);
                    }
                });
            }
            if (fk == null || !dw.dragFluid(fk, Simulation.SIMULATE)) continue;
            bounds.add(new IGhostIngredientHandler.Target<I>(){

                public Rect2i getArea() {
                    return MIGhostIngredientHandler.getWidgetBounds(cw);
                }

                public void accept(I ingredient) {
                    dw.dragFluid(fk, Simulation.ACT);
                }
            });
        }
        final AbstractContainerMenu handler = gui.getMenu();
        for (final Slot slot : handler.slots) {
            if (!(slot instanceof ReiDraggable)) continue;
            dw = (ReiDraggable)slot;
            if (ik != null && dw.dragItem(ik, Simulation.SIMULATE)) {
                bounds.add(new IGhostIngredientHandler.Target<I>(){

                    public Rect2i getArea() {
                        return MIGhostIngredientHandler.getSlotTarget(slot, gui);
                    }

                    public void accept(I ingredient) {
                        if (dw.dragItem(ik, Simulation.ACT)) {
                            int slotId = handler.slots.indexOf((Object)slot);
                            new DoSlotDraggingPacket(handler.containerId, slotId, ik).sendToServer();
                        }
                    }
                });
            }
            if (fk == null || !dw.dragFluid(fk, Simulation.SIMULATE)) continue;
            bounds.add(new IGhostIngredientHandler.Target<I>(){

                public Rect2i getArea() {
                    return MIGhostIngredientHandler.getSlotTarget(slot, gui);
                }

                public void accept(I ingredient) {
                    if (dw.dragFluid(fk, Simulation.ACT)) {
                        int slotId = handler.slots.indexOf((Object)slot);
                        new DoSlotDraggingPacket(handler.containerId, slotId, fk).sendToServer();
                    }
                }
            });
        }
        return bounds;
    }

    public void onComplete() {
    }

    private static Rect2i getWidgetBounds(AbstractWidget cw) {
        return new Rect2i(cw.getX(), cw.getY(), cw.getWidth(), cw.getHeight());
    }

    private static Rect2i getSlotTarget(Slot slot, MIHandledScreen<?> screen) {
        return new Rect2i(slot.x + screen.getX(), slot.y + screen.getY(), 16, 16);
    }
}

