/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.jei;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.machines.gui.MachineMenuClient;
import aztech.modern_industrialization.machines.guicomponents.ReiSlotLockingClient;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.network.machines.ReiLockSlotsPacket;
import java.util.Optional;
import java.util.function.Supplier;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IRecipeCatalystLookup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

class MachineSlotLockingHandler
implements IRecipeTransferHandler<MachineMenuClient, RecipeHolder<MachineRecipe>> {
    private final Supplier<IJeiRuntime> runtimeSupplier;
    private final RecipeType<RecipeHolder<MachineRecipe>> type;
    private final IRecipeTransferHandlerHelper helper;

    public MachineSlotLockingHandler(IRecipeTransferHandlerHelper helper, Supplier<IJeiRuntime> runtimeSupplier, RecipeType<RecipeHolder<MachineRecipe>> type) {
        this.helper = helper;
        this.runtimeSupplier = runtimeSupplier;
        this.type = type;
    }

    private IRecipeCatalystLookup getLookup() {
        IJeiRuntime runtime = this.runtimeSupplier.get();
        if (runtime != null) {
            return runtime.getRecipeManager().createRecipeCatalystLookup(this.type);
        }
        return null;
    }

    public Class<? extends MachineMenuClient> getContainerClass() {
        return MachineMenuClient.class;
    }

    public Optional<MenuType<MachineMenuClient>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<RecipeHolder<MachineRecipe>> getRecipeType() {
        return this.type;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(MachineMenuClient menu, RecipeHolder<MachineRecipe> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (!this.canApply(menu)) {
            return this.helper.createInternalError();
        }
        ReiSlotLockingClient slotLocking = menu.getComponent(ReiSlotLockingClient.class);
        if (slotLocking == null || !slotLocking.isLockingAllowed()) {
            return this.helper.createInternalError();
        }
        if (doTransfer) {
            new ReiLockSlotsPacket(menu.containerId, recipe.id()).sendToServer();
        }
        return null;
    }

    private boolean canApply(MachineMenuClient handler) {
        String blockId = handler.guiParams.blockId;
        IRecipeCatalystLookup lookup = this.getLookup();
        if (lookup == null) {
            return false;
        }
        Item item = (Item)BuiltInRegistries.ITEM.get((ResourceLocation)new MIIdentifier(blockId));
        return lookup.getItemStack().anyMatch(is -> is.is(item));
    }
}

