/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.jei;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.compat.viewer.impl.jei.ViewerCategoryJei;
import aztech.modern_industrialization.compat.viewer.usage.ViewerSetup;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.plugincompatibilities.api.REIPluginCompatIgnore;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

@REIPluginCompatIgnore
@JeiPlugin
public class ViewerPluginJei
implements IModPlugin {
    private static final ResourceLocation ID = new MIIdentifier("viewer");
    private final List<ViewerCategoryJei<?>> categories = new ArrayList();

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.categories.clear();
        for (ViewerCategory<?> category : ViewerSetup.setup()) {
            this.categories.add(new ViewerCategoryJei(registration.getJeiHelpers(), category));
        }
        registration.addRecipeCategories(this.categories.toArray(new IRecipeCategory[0]));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (ViewerCategoryJei<?> category : this.categories) {
            category.wrapped.buildWorkstations(items -> {
                for (ItemLike item : items) {
                    registration.addRecipeCatalyst(item.asItem().getDefaultInstance(), new RecipeType[]{category.recipeType});
                }
            });
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        for (ViewerCategoryJei<?> category : this.categories) {
            ViewerPluginJei.registerCategoryRecipes(registration, category);
        }
    }

    private static <D> void registerCategoryRecipes(IRecipeRegistration registration, ViewerCategoryJei<D> category) {
        ClientLevel level = Minecraft.getInstance().level;
        ArrayList recipes = new ArrayList();
        category.wrapped.buildRecipes(level.getRecipeManager(), level.registryAccess(), recipes::add);
        registration.addRecipes(category.recipeType, recipes);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

