/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.usage;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class MultiblockCategory
extends ViewerCategory<Recipe> {
    private static final int SLOTS = 6;
    private static final int MARGIN = 10;
    private static final int H = 38;
    private static final int W = 138;

    protected MultiblockCategory() {
        super(Recipe.class, (ResourceLocation)new MIIdentifier("multiblock_shapes"), (Component)MIText.MultiblockMaterials.text(), MIItem.WRENCH.stack(), 138, 38);
    }

    @Override
    public void buildWorkstations(ViewerCategory.WorkstationConsumer consumer) {
    }

    @Override
    public void buildRecipes(RecipeManager recipeManager, RegistryAccess registryAccess, Consumer<Recipe> consumer) {
        for (Tuple<String, ShapeTemplate> entry : ReiMachineRecipes.multiblockShapes) {
            consumer.accept(new Recipe((String)entry.getA(), (ShapeTemplate)entry.getB()));
        }
    }

    @Override
    public void buildLayout(Recipe recipe, ViewerCategory.LayoutBuilder builder) {
        for (int i = 0; i < 6; ++i) {
            ViewerCategory.SlotBuilder slot = builder.inputSlot(10 + i * 20, 10);
            if (i >= recipe.materials.size()) continue;
            slot.item(recipe.materials.get(i));
        }
        builder.invisibleOutput(recipe.materials.get(0));
    }

    @Override
    public void buildWidgets(Recipe recipe, ViewerCategory.WidgetList widgets) {
    }

    protected static class Recipe {
        public final ItemStack controller;
        public final List<ItemStack> materials = new ArrayList<ItemStack>();

        public Recipe(String controller, ShapeTemplate shapeTemplate) {
            this.controller = ((Item)BuiltInRegistries.ITEM.get((ResourceLocation)new MIIdentifier(controller))).getDefaultInstance();
            this.materials.add(this.controller);
            TreeMap<Item, Integer> materials = new TreeMap<Item, Integer>(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)));
            for (Map.Entry<BlockPos, SimpleMember> entry : shapeTemplate.simpleMembers.entrySet()) {
                BlockState state = entry.getValue().getPreviewState();
                Item item = state.getBlock().asItem();
                if (item == Items.AIR) continue;
                materials.put(item, 1 + materials.getOrDefault(item, 0));
            }
            for (Map.Entry<Object, SimpleMember> entry : materials.entrySet()) {
                this.materials.add(new ItemStack((ItemLike)entry.getKey(), ((Integer)((Object)entry.getValue())).intValue()));
            }
        }
    }
}

