/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.model;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.datagen.model.MachineCasingImitations;
import aztech.modern_industrialization.datagen.model.UseBlockModelModelBuilder;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.materials.MIMaterials;
import aztech.modern_industrialization.materials.part.MIParts;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class MachineCasingsProvider
extends ModelProvider<BlockModelBuilder> {
    public MachineCasingsProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "modern_industrialization", "machine_casing", BlockModelBuilder::new, existingFileHelper);
    }

    protected void registerModels() {
        this.imitateBlock(CableTier.LV.casing, MIBlock.BASIC_MACHINE_HULL.asBlock());
        this.imitateBlock(CableTier.MV.casing, MIBlock.ADVANCED_MACHINE_HULL.asBlock());
        this.imitateBlock(CableTier.HV.casing, MIBlock.TURBO_MACHINE_HULL.asBlock());
        this.imitateBlock(CableTier.EV.casing, MIBlock.HIGHLY_ADVANCED_MACHINE_HULL.asBlock());
        this.imitateBlock(CableTier.SUPERCONDUCTOR.casing, MIBlock.QUANTUM_MACHINE_HULL.asBlock());
        this.imitateBlock(MachineCasings.FIREBRICKS, MIBlock.BLOCK_FIRE_CLAY_BRICKS.asBlock());
        this.imitateBlock(MachineCasings.BRICKS, Blocks.BRICKS);
        this.imitateBlock(MachineCasings.BRONZE, MIMaterials.BRONZE.getPart(MIParts.MACHINE_CASING).asBlock());
        this.imitateBlock(MachineCasings.BRONZE_PLATED_BRICKS, MIMaterials.BRONZE.getPart(MIParts.MACHINE_CASING_SPECIAL).asBlock());
        this.imitateBlock(MachineCasings.CLEAN_STAINLESS_STEEL, MIMaterials.STAINLESS_STEEL.getPart(MIParts.MACHINE_CASING_SPECIAL).asBlock());
        this.imitateBlock(MachineCasings.FROSTPROOF, MIMaterials.ALUMINUM.getPart(MIParts.MACHINE_CASING_SPECIAL).asBlock());
        this.imitateBlock(MachineCasings.HEATPROOF, MIMaterials.INVAR.getPart(MIParts.MACHINE_CASING_SPECIAL).asBlock());
        this.imitateBlock(MachineCasings.STAINLESS_STEEL_PIPE, MIMaterials.STAINLESS_STEEL.getPart(MIParts.MACHINE_CASING_PIPE).asBlock());
        this.imitateBlock(MachineCasings.STEEL, MIMaterials.STEEL.getPart(MIParts.MACHINE_CASING).asBlock());
        this.imitateBlock(MachineCasings.TITANIUM, MIMaterials.TITANIUM.getPart(MIParts.MACHINE_CASING).asBlock());
        this.imitateBlock(MachineCasings.TITANIUM_PIPE, MIMaterials.TITANIUM.getPart(MIParts.MACHINE_CASING_PIPE).asBlock());
        this.imitateBlock(MachineCasings.SOLID_TITANIUM, MIMaterials.TITANIUM.getPart(MIParts.MACHINE_CASING_SPECIAL).asBlock());
        this.imitateBlock(MachineCasings.NUCLEAR, MIMaterials.NUCLEAR_ALLOY.getPart(MIParts.MACHINE_CASING_SPECIAL).asBlock());
        this.imitateBlock(MachineCasings.PLASMA_HANDLING_IRIDIUM, MIMaterials.IRIDIUM.getPart(MIParts.MACHINE_CASING_SPECIAL).asBlock());
        this.cubeBottomTop(MachineCasings.BRICKED_BRONZE, "block/casings/bricked_bronze", "block/fire_clay_bricks", "block/bronze_machine_casing");
        this.cubeBottomTop(MachineCasings.BRICKED_STEEL, "block/casings/bricked_steel", "block/fire_clay_bricks", "block/steel_machine_casing");
        this.cubeAll(MachineCasings.CONFIGURABLE_TANK, "block/casings/configurable_tank");
        this.cubeAll(MachineCasings.STEEL_CRATE, "block/casings/steel_crate");
        for (Map.Entry<MachineCasing, ResourceLocation> entry : MachineCasingImitations.imitationsToGenerate.entrySet()) {
            this.imitateBlock(entry.getKey(), (Block)BuiltInRegistries.BLOCK.getOrThrow(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)entry.getValue())));
        }
    }

    private void imitateBlock(MachineCasing casing, Block block) {
        ((BlockModelBuilder)this.getBuilder(casing.name)).customLoader((bmb, existingFileHelper) -> new UseBlockModelModelBuilder<BlockModelBuilder>(block, (BlockModelBuilder)bmb, (ExistingFileHelper)existingFileHelper));
    }

    private void cubeBottomTop(MachineCasing casing, String side, String bottom, String top) {
        this.cubeBottomTop(casing.name, MI.id(side), MI.id(bottom), MI.id(top));
    }

    private void cubeAll(MachineCasing casing, String side) {
        this.cubeAll(casing.name, MI.id(side));
    }

    public String getName() {
        return "Machine Casings";
    }
}

